package zio.aws.appmesh
import zio.aws.appmesh.model.UpdateVirtualServiceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.appmesh.AppMeshAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.appmesh.model.{
  UpdateMeshRequest,
  DescribeVirtualRouterRequest,
  UpdateVirtualGatewayRequest,
  DeleteRouteRequest,
  UpdateVirtualNodeRequest,
  ListRoutesRequest,
  DescribeVirtualNodeRequest,
  CreateMeshRequest,
  ListVirtualServicesRequest,
  UpdateVirtualRouterRequest,
  CreateGatewayRouteRequest,
  DeleteVirtualRouterRequest,
  ListVirtualNodesRequest,
  CreateVirtualServiceRequest,
  DeleteVirtualServiceRequest,
  DeleteVirtualGatewayRequest,
  ListTagsForResourceRequest,
  DeleteMeshRequest,
  CreateRouteRequest,
  DescribeVirtualGatewayRequest,
  UpdateGatewayRouteRequest,
  UpdateVirtualServiceRequest,
  ListMeshesRequest,
  DeleteVirtualNodeRequest,
  DescribeGatewayRouteRequest,
  UpdateRouteRequest,
  DescribeVirtualServiceRequest,
  CreateVirtualNodeRequest,
  DescribeRouteRequest,
  ListGatewayRoutesRequest,
  UntagResourceRequest,
  ListVirtualGatewaysRequest,
  ListVirtualRoutersRequest,
  DescribeMeshRequest,
  CreateVirtualGatewayRequest,
  CreateVirtualRouterRequest,
  TagResourceRequest,
  DeleteGatewayRouteRequest
}
import zio.stream.ZStream
object AppMeshMock extends Mock[AppMesh] {
  object DescribeRoute
      extends Effect[
        DescribeRouteRequest,
        AwsError,
        zio.aws.appmesh.model.DescribeRouteResponse.ReadOnly
      ]
  object CreateVirtualNode
      extends Effect[
        CreateVirtualNodeRequest,
        AwsError,
        zio.aws.appmesh.model.CreateVirtualNodeResponse.ReadOnly
      ]
  object ListGatewayRoutes
      extends Stream[
        ListGatewayRoutesRequest,
        AwsError,
        zio.aws.appmesh.model.GatewayRouteRef.ReadOnly
      ]
  object ListGatewayRoutesPaginated
      extends Effect[
        ListGatewayRoutesRequest,
        AwsError,
        zio.aws.appmesh.model.ListGatewayRoutesResponse.ReadOnly
      ]
  object CreateRoute
      extends Effect[
        CreateRouteRequest,
        AwsError,
        zio.aws.appmesh.model.CreateRouteResponse.ReadOnly
      ]
  object DeleteRoute
      extends Effect[
        DeleteRouteRequest,
        AwsError,
        zio.aws.appmesh.model.DeleteRouteResponse.ReadOnly
      ]
  object UpdateGatewayRoute
      extends Effect[
        UpdateGatewayRouteRequest,
        AwsError,
        zio.aws.appmesh.model.UpdateGatewayRouteResponse.ReadOnly
      ]
  object ListVirtualGateways
      extends Stream[
        ListVirtualGatewaysRequest,
        AwsError,
        zio.aws.appmesh.model.VirtualGatewayRef.ReadOnly
      ]
  object ListVirtualGatewaysPaginated
      extends Effect[
        ListVirtualGatewaysRequest,
        AwsError,
        zio.aws.appmesh.model.ListVirtualGatewaysResponse.ReadOnly
      ]
  object UpdateRoute
      extends Effect[
        UpdateRouteRequest,
        AwsError,
        zio.aws.appmesh.model.UpdateRouteResponse.ReadOnly
      ]
  object ListVirtualRouters
      extends Stream[
        ListVirtualRoutersRequest,
        AwsError,
        zio.aws.appmesh.model.VirtualRouterRef.ReadOnly
      ]
  object ListVirtualRoutersPaginated
      extends Effect[
        ListVirtualRoutersRequest,
        AwsError,
        zio.aws.appmesh.model.ListVirtualRoutersResponse.ReadOnly
      ]
  object DescribeGatewayRoute
      extends Effect[
        DescribeGatewayRouteRequest,
        AwsError,
        zio.aws.appmesh.model.DescribeGatewayRouteResponse.ReadOnly
      ]
  object DeleteVirtualGateway
      extends Effect[
        DeleteVirtualGatewayRequest,
        AwsError,
        zio.aws.appmesh.model.DeleteVirtualGatewayResponse.ReadOnly
      ]
  object UpdateVirtualGateway
      extends Effect[
        UpdateVirtualGatewayRequest,
        AwsError,
        zio.aws.appmesh.model.UpdateVirtualGatewayResponse.ReadOnly
      ]
  object ListRoutes
      extends Stream[
        ListRoutesRequest,
        AwsError,
        zio.aws.appmesh.model.RouteRef.ReadOnly
      ]
  object ListRoutesPaginated
      extends Effect[
        ListRoutesRequest,
        AwsError,
        zio.aws.appmesh.model.ListRoutesResponse.ReadOnly
      ]
  object CreateVirtualRouter
      extends Effect[
        CreateVirtualRouterRequest,
        AwsError,
        zio.aws.appmesh.model.CreateVirtualRouterResponse.ReadOnly
      ]
  object CreateVirtualService
      extends Effect[
        CreateVirtualServiceRequest,
        AwsError,
        zio.aws.appmesh.model.CreateVirtualServiceResponse.ReadOnly
      ]
  object UpdateVirtualNode
      extends Effect[
        UpdateVirtualNodeRequest,
        AwsError,
        zio.aws.appmesh.model.UpdateVirtualNodeResponse.ReadOnly
      ]
  object UpdateMesh
      extends Effect[
        UpdateMeshRequest,
        AwsError,
        zio.aws.appmesh.model.UpdateMeshResponse.ReadOnly
      ]
  object DeleteVirtualService
      extends Effect[
        DeleteVirtualServiceRequest,
        AwsError,
        zio.aws.appmesh.model.DeleteVirtualServiceResponse.ReadOnly
      ]
  object DescribeVirtualService
      extends Effect[
        DescribeVirtualServiceRequest,
        AwsError,
        zio.aws.appmesh.model.DescribeVirtualServiceResponse.ReadOnly
      ]
  object DeleteGatewayRoute
      extends Effect[
        DeleteGatewayRouteRequest,
        AwsError,
        zio.aws.appmesh.model.DeleteGatewayRouteResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.appmesh.model.UntagResourceResponse.ReadOnly
      ]
  object DeleteVirtualRouter
      extends Effect[
        DeleteVirtualRouterRequest,
        AwsError,
        zio.aws.appmesh.model.DeleteVirtualRouterResponse.ReadOnly
      ]
  object DescribeMesh
      extends Effect[
        DescribeMeshRequest,
        AwsError,
        zio.aws.appmesh.model.DescribeMeshResponse.ReadOnly
      ]
  object DescribeVirtualGateway
      extends Effect[
        DescribeVirtualGatewayRequest,
        AwsError,
        zio.aws.appmesh.model.DescribeVirtualGatewayResponse.ReadOnly
      ]
  object UpdateVirtualRouter
      extends Effect[
        UpdateVirtualRouterRequest,
        AwsError,
        zio.aws.appmesh.model.UpdateVirtualRouterResponse.ReadOnly
      ]
  object DeleteMesh
      extends Effect[
        DeleteMeshRequest,
        AwsError,
        zio.aws.appmesh.model.DeleteMeshResponse.ReadOnly
      ]
  object DescribeVirtualNode
      extends Effect[
        DescribeVirtualNodeRequest,
        AwsError,
        zio.aws.appmesh.model.DescribeVirtualNodeResponse.ReadOnly
      ]
  object DescribeVirtualRouter
      extends Effect[
        DescribeVirtualRouterRequest,
        AwsError,
        zio.aws.appmesh.model.DescribeVirtualRouterResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Stream[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.appmesh.model.TagRef.ReadOnly
      ]
  object ListTagsForResourcePaginated
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.appmesh.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.appmesh.model.TagResourceResponse.ReadOnly
      ]
  object ListVirtualNodes
      extends Stream[
        ListVirtualNodesRequest,
        AwsError,
        zio.aws.appmesh.model.VirtualNodeRef.ReadOnly
      ]
  object ListVirtualNodesPaginated
      extends Effect[
        ListVirtualNodesRequest,
        AwsError,
        zio.aws.appmesh.model.ListVirtualNodesResponse.ReadOnly
      ]
  object ListMeshes
      extends Stream[
        ListMeshesRequest,
        AwsError,
        zio.aws.appmesh.model.MeshRef.ReadOnly
      ]
  object ListMeshesPaginated
      extends Effect[
        ListMeshesRequest,
        AwsError,
        zio.aws.appmesh.model.ListMeshesResponse.ReadOnly
      ]
  object UpdateVirtualService
      extends Effect[UpdateVirtualServiceRequest, AwsError, ReadOnly]
  object ListVirtualServices
      extends Stream[
        ListVirtualServicesRequest,
        AwsError,
        zio.aws.appmesh.model.VirtualServiceRef.ReadOnly
      ]
  object ListVirtualServicesPaginated
      extends Effect[
        ListVirtualServicesRequest,
        AwsError,
        zio.aws.appmesh.model.ListVirtualServicesResponse.ReadOnly
      ]
  object DeleteVirtualNode
      extends Effect[
        DeleteVirtualNodeRequest,
        AwsError,
        zio.aws.appmesh.model.DeleteVirtualNodeResponse.ReadOnly
      ]
  object CreateGatewayRoute
      extends Effect[
        CreateGatewayRouteRequest,
        AwsError,
        zio.aws.appmesh.model.CreateGatewayRouteResponse.ReadOnly
      ]
  object CreateMesh
      extends Effect[
        CreateMeshRequest,
        AwsError,
        zio.aws.appmesh.model.CreateMeshResponse.ReadOnly
      ]
  object CreateVirtualGateway
      extends Effect[
        CreateVirtualGatewayRequest,
        AwsError,
        zio.aws.appmesh.model.CreateVirtualGatewayResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AppMesh] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, AppMesh] { rts =>
        zio.ZIO.succeed {
          new AppMesh {
            val api: AppMeshAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): AppMesh = this
            def describeRoute(request: DescribeRouteRequest): IO[
              AwsError,
              zio.aws.appmesh.model.DescribeRouteResponse.ReadOnly
            ] = proxy(DescribeRoute, request)
            def createVirtualNode(request: CreateVirtualNodeRequest): IO[
              AwsError,
              zio.aws.appmesh.model.CreateVirtualNodeResponse.ReadOnly
            ] = proxy(CreateVirtualNode, request)
            def listGatewayRoutes(request: ListGatewayRoutesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.appmesh.model.GatewayRouteRef.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListGatewayRoutes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listGatewayRoutesPaginated(
                request: ListGatewayRoutesRequest
            ): IO[
              AwsError,
              zio.aws.appmesh.model.ListGatewayRoutesResponse.ReadOnly
            ] = proxy(ListGatewayRoutesPaginated, request)
            def createRoute(request: CreateRouteRequest): IO[
              AwsError,
              zio.aws.appmesh.model.CreateRouteResponse.ReadOnly
            ] = proxy(CreateRoute, request)
            def deleteRoute(request: DeleteRouteRequest): IO[
              AwsError,
              zio.aws.appmesh.model.DeleteRouteResponse.ReadOnly
            ] = proxy(DeleteRoute, request)
            def updateGatewayRoute(request: UpdateGatewayRouteRequest): IO[
              AwsError,
              zio.aws.appmesh.model.UpdateGatewayRouteResponse.ReadOnly
            ] = proxy(UpdateGatewayRoute, request)
            def listVirtualGateways(
                request: ListVirtualGatewaysRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appmesh.model.VirtualGatewayRef.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVirtualGateways, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVirtualGatewaysPaginated(
                request: ListVirtualGatewaysRequest
            ): IO[
              AwsError,
              zio.aws.appmesh.model.ListVirtualGatewaysResponse.ReadOnly
            ] = proxy(ListVirtualGatewaysPaginated, request)
            def updateRoute(request: UpdateRouteRequest): IO[
              AwsError,
              zio.aws.appmesh.model.UpdateRouteResponse.ReadOnly
            ] = proxy(UpdateRoute, request)
            def listVirtualRouters(request: ListVirtualRoutersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.appmesh.model.VirtualRouterRef.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVirtualRouters, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVirtualRoutersPaginated(
                request: ListVirtualRoutersRequest
            ): IO[
              AwsError,
              zio.aws.appmesh.model.ListVirtualRoutersResponse.ReadOnly
            ] = proxy(ListVirtualRoutersPaginated, request)
            def describeGatewayRoute(request: DescribeGatewayRouteRequest): IO[
              AwsError,
              zio.aws.appmesh.model.DescribeGatewayRouteResponse.ReadOnly
            ] = proxy(DescribeGatewayRoute, request)
            def deleteVirtualGateway(request: DeleteVirtualGatewayRequest): IO[
              AwsError,
              zio.aws.appmesh.model.DeleteVirtualGatewayResponse.ReadOnly
            ] = proxy(DeleteVirtualGateway, request)
            def updateVirtualGateway(request: UpdateVirtualGatewayRequest): IO[
              AwsError,
              zio.aws.appmesh.model.UpdateVirtualGatewayResponse.ReadOnly
            ] = proxy(UpdateVirtualGateway, request)
            def listRoutes(
                request: ListRoutesRequest
            ): ZStream[Any, AwsError, zio.aws.appmesh.model.RouteRef.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListRoutes, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listRoutesPaginated(
                request: ListRoutesRequest
            ): IO[AwsError, zio.aws.appmesh.model.ListRoutesResponse.ReadOnly] =
              proxy(ListRoutesPaginated, request)
            def createVirtualRouter(request: CreateVirtualRouterRequest): IO[
              AwsError,
              zio.aws.appmesh.model.CreateVirtualRouterResponse.ReadOnly
            ] = proxy(CreateVirtualRouter, request)
            def createVirtualService(request: CreateVirtualServiceRequest): IO[
              AwsError,
              zio.aws.appmesh.model.CreateVirtualServiceResponse.ReadOnly
            ] = proxy(CreateVirtualService, request)
            def updateVirtualNode(request: UpdateVirtualNodeRequest): IO[
              AwsError,
              zio.aws.appmesh.model.UpdateVirtualNodeResponse.ReadOnly
            ] = proxy(UpdateVirtualNode, request)
            def updateMesh(
                request: UpdateMeshRequest
            ): IO[AwsError, zio.aws.appmesh.model.UpdateMeshResponse.ReadOnly] =
              proxy(UpdateMesh, request)
            def deleteVirtualService(request: DeleteVirtualServiceRequest): IO[
              AwsError,
              zio.aws.appmesh.model.DeleteVirtualServiceResponse.ReadOnly
            ] = proxy(DeleteVirtualService, request)
            def describeVirtualService(
                request: DescribeVirtualServiceRequest
            ): IO[
              AwsError,
              zio.aws.appmesh.model.DescribeVirtualServiceResponse.ReadOnly
            ] = proxy(DescribeVirtualService, request)
            def deleteGatewayRoute(request: DeleteGatewayRouteRequest): IO[
              AwsError,
              zio.aws.appmesh.model.DeleteGatewayRouteResponse.ReadOnly
            ] = proxy(DeleteGatewayRoute, request)
            def untagResource(request: UntagResourceRequest): IO[
              AwsError,
              zio.aws.appmesh.model.UntagResourceResponse.ReadOnly
            ] = proxy(UntagResource, request)
            def deleteVirtualRouter(request: DeleteVirtualRouterRequest): IO[
              AwsError,
              zio.aws.appmesh.model.DeleteVirtualRouterResponse.ReadOnly
            ] = proxy(DeleteVirtualRouter, request)
            def describeMesh(request: DescribeMeshRequest): IO[
              AwsError,
              zio.aws.appmesh.model.DescribeMeshResponse.ReadOnly
            ] = proxy(DescribeMesh, request)
            def describeVirtualGateway(
                request: DescribeVirtualGatewayRequest
            ): IO[
              AwsError,
              zio.aws.appmesh.model.DescribeVirtualGatewayResponse.ReadOnly
            ] = proxy(DescribeVirtualGateway, request)
            def updateVirtualRouter(request: UpdateVirtualRouterRequest): IO[
              AwsError,
              zio.aws.appmesh.model.UpdateVirtualRouterResponse.ReadOnly
            ] = proxy(UpdateVirtualRouter, request)
            def deleteMesh(
                request: DeleteMeshRequest
            ): IO[AwsError, zio.aws.appmesh.model.DeleteMeshResponse.ReadOnly] =
              proxy(DeleteMesh, request)
            def describeVirtualNode(request: DescribeVirtualNodeRequest): IO[
              AwsError,
              zio.aws.appmesh.model.DescribeVirtualNodeResponse.ReadOnly
            ] = proxy(DescribeVirtualNode, request)
            def describeVirtualRouter(
                request: DescribeVirtualRouterRequest
            ): IO[
              AwsError,
              zio.aws.appmesh.model.DescribeVirtualRouterResponse.ReadOnly
            ] = proxy(DescribeVirtualRouter, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): ZStream[Any, AwsError, zio.aws.appmesh.model.TagRef.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListTagsForResource, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listTagsForResourcePaginated(
                request: ListTagsForResourceRequest
            ): IO[
              AwsError,
              zio.aws.appmesh.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResourcePaginated, request)
            def tagResource(request: TagResourceRequest): IO[
              AwsError,
              zio.aws.appmesh.model.TagResourceResponse.ReadOnly
            ] = proxy(TagResource, request)
            def listVirtualNodes(request: ListVirtualNodesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.appmesh.model.VirtualNodeRef.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVirtualNodes, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVirtualNodesPaginated(request: ListVirtualNodesRequest): IO[
              AwsError,
              zio.aws.appmesh.model.ListVirtualNodesResponse.ReadOnly
            ] = proxy(ListVirtualNodesPaginated, request)
            def listMeshes(
                request: ListMeshesRequest
            ): ZStream[Any, AwsError, zio.aws.appmesh.model.MeshRef.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListMeshes, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listMeshesPaginated(
                request: ListMeshesRequest
            ): IO[AwsError, zio.aws.appmesh.model.ListMeshesResponse.ReadOnly] =
              proxy(ListMeshesPaginated, request)
            def updateVirtualService(
                request: UpdateVirtualServiceRequest
            ): IO[AwsError, ReadOnly] = proxy(UpdateVirtualService, request)
            def listVirtualServices(
                request: ListVirtualServicesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.appmesh.model.VirtualServiceRef.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListVirtualServices, request)
                }
                .getOrThrowFiberFailure()
            }
            def listVirtualServicesPaginated(
                request: ListVirtualServicesRequest
            ): IO[
              AwsError,
              zio.aws.appmesh.model.ListVirtualServicesResponse.ReadOnly
            ] = proxy(ListVirtualServicesPaginated, request)
            def deleteVirtualNode(request: DeleteVirtualNodeRequest): IO[
              AwsError,
              zio.aws.appmesh.model.DeleteVirtualNodeResponse.ReadOnly
            ] = proxy(DeleteVirtualNode, request)
            def createGatewayRoute(request: CreateGatewayRouteRequest): IO[
              AwsError,
              zio.aws.appmesh.model.CreateGatewayRouteResponse.ReadOnly
            ] = proxy(CreateGatewayRoute, request)
            def createMesh(
                request: CreateMeshRequest
            ): IO[AwsError, zio.aws.appmesh.model.CreateMeshResponse.ReadOnly] =
              proxy(CreateMesh, request)
            def createVirtualGateway(request: CreateVirtualGatewayRequest): IO[
              AwsError,
              zio.aws.appmesh.model.CreateVirtualGatewayResponse.ReadOnly
            ] = proxy(CreateVirtualGateway, request)
          }
        }
      }
    }
  }
}
