package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.MaxConnections
import scala.jdk.CollectionConverters._
final case class VirtualNodeTcpConnectionPool(maxConnections: MaxConnections) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualNodeTcpConnectionPool = {
    import VirtualNodeTcpConnectionPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualNodeTcpConnectionPool
      .builder()
      .maxConnections(MaxConnections.unwrap(maxConnections): Integer)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualNodeTcpConnectionPool.ReadOnly =
    zio.aws.appmesh.model.VirtualNodeTcpConnectionPool.wrap(buildAwsValue())
}
object VirtualNodeTcpConnectionPool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualNodeTcpConnectionPool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualNodeTcpConnectionPool =
      zio.aws.appmesh.model.VirtualNodeTcpConnectionPool(maxConnections)
    def maxConnections: MaxConnections
    def getMaxConnections: ZIO[Any, Nothing, MaxConnections] =
      ZIO.succeed(maxConnections)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeTcpConnectionPool
  ) extends zio.aws.appmesh.model.VirtualNodeTcpConnectionPool.ReadOnly {
    override val maxConnections: MaxConnections =
      zio.aws.appmesh.model.primitives.MaxConnections(impl.maxConnections())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeTcpConnectionPool
  ): zio.aws.appmesh.model.VirtualNodeTcpConnectionPool.ReadOnly = new Wrapper(
    impl
  )
}
