package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeRouteResponse(route: zio.aws.appmesh.model.RouteData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DescribeRouteResponse = {
    import DescribeRouteResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DescribeRouteResponse
      .builder()
      .route(route.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DescribeRouteResponse.ReadOnly =
    zio.aws.appmesh.model.DescribeRouteResponse.wrap(buildAwsValue())
}
object DescribeRouteResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DescribeRouteResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DescribeRouteResponse =
      zio.aws.appmesh.model.DescribeRouteResponse(route.asEditable)
    def route: zio.aws.appmesh.model.RouteData.ReadOnly
    def getRoute: ZIO[Any, Nothing, zio.aws.appmesh.model.RouteData.ReadOnly] =
      ZIO.succeed(route)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeRouteResponse
  ) extends zio.aws.appmesh.model.DescribeRouteResponse.ReadOnly {
    override val route: zio.aws.appmesh.model.RouteData.ReadOnly =
      zio.aws.appmesh.model.RouteData.wrap(impl.route())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeRouteResponse
  ): zio.aws.appmesh.model.DescribeRouteResponse.ReadOnly = new Wrapper(impl)
}
