package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.{PercentInt, ResourceName}
import scala.jdk.CollectionConverters._
final case class WeightedTarget(virtualNode: ResourceName, weight: PercentInt) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.WeightedTarget = {
    import WeightedTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.WeightedTarget
      .builder()
      .virtualNode(ResourceName.unwrap(virtualNode): java.lang.String)
      .weight(PercentInt.unwrap(weight): Integer)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.WeightedTarget.ReadOnly =
    zio.aws.appmesh.model.WeightedTarget.wrap(buildAwsValue())
}
object WeightedTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.WeightedTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.WeightedTarget =
      zio.aws.appmesh.model.WeightedTarget(virtualNode, weight)
    def virtualNode: ResourceName
    def weight: PercentInt
    def getVirtualNode: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualNode)
    def getWeight: ZIO[Any, Nothing, PercentInt] = ZIO.succeed(weight)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.WeightedTarget
  ) extends zio.aws.appmesh.model.WeightedTarget.ReadOnly {
    override val virtualNode: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualNode())
    override val weight: PercentInt =
      zio.aws.appmesh.model.primitives.PercentInt(impl.weight())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.WeightedTarget
  ): zio.aws.appmesh.model.WeightedTarget.ReadOnly = new Wrapper(impl)
}
