package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.MaxRequests
import scala.jdk.CollectionConverters._
final case class VirtualNodeHttp2ConnectionPool(maxRequests: MaxRequests) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualNodeHttp2ConnectionPool = {
    import VirtualNodeHttp2ConnectionPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualNodeHttp2ConnectionPool
      .builder()
      .maxRequests(MaxRequests.unwrap(maxRequests): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool.ReadOnly =
    zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool.wrap(buildAwsValue())
}
object VirtualNodeHttp2ConnectionPool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualNodeHttp2ConnectionPool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool =
      zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool(maxRequests)
    def maxRequests: MaxRequests
    def getMaxRequests: ZIO[Any, Nothing, MaxRequests] =
      ZIO.succeed(maxRequests)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeHttp2ConnectionPool
  ) extends zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool.ReadOnly {
    override val maxRequests: MaxRequests =
      zio.aws.appmesh.model.primitives.MaxRequests(impl.maxRequests())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeHttp2ConnectionPool
  ): zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool.ReadOnly =
    new Wrapper(impl)
}
