package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListGatewayRoutesResponse(
    gatewayRoutes: Iterable[zio.aws.appmesh.model.GatewayRouteRef],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse = {
    import ListGatewayRoutesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse
      .builder()
      .gatewayRoutes(gatewayRoutes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListGatewayRoutesResponse.ReadOnly =
    zio.aws.appmesh.model.ListGatewayRoutesResponse.wrap(buildAwsValue())
}
object ListGatewayRoutesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListGatewayRoutesResponse =
      zio.aws.appmesh.model.ListGatewayRoutesResponse(
        gatewayRoutes.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def gatewayRoutes: List[zio.aws.appmesh.model.GatewayRouteRef.ReadOnly]
    def nextToken: Optional[String]
    def getGatewayRoutes: ZIO[Any, Nothing, List[
      zio.aws.appmesh.model.GatewayRouteRef.ReadOnly
    ]] = ZIO.succeed(gatewayRoutes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse
  ) extends zio.aws.appmesh.model.ListGatewayRoutesResponse.ReadOnly {
    override val gatewayRoutes
        : List[zio.aws.appmesh.model.GatewayRouteRef.ReadOnly] = impl
      .gatewayRoutes()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.GatewayRouteRef.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListGatewayRoutesResponse
  ): zio.aws.appmesh.model.ListGatewayRoutesResponse.ReadOnly = new Wrapper(
    impl
  )
}
