package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListVirtualNodesResponse(
    nextToken: Optional[String] = Optional.Absent,
    virtualNodes: Iterable[zio.aws.appmesh.model.VirtualNodeRef]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse = {
    import ListVirtualNodesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .virtualNodes(virtualNodes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListVirtualNodesResponse.ReadOnly =
    zio.aws.appmesh.model.ListVirtualNodesResponse.wrap(buildAwsValue())
}
object ListVirtualNodesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListVirtualNodesResponse =
      zio.aws.appmesh.model.ListVirtualNodesResponse(
        nextToken.map(value => value),
        virtualNodes.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[String]
    def virtualNodes: List[zio.aws.appmesh.model.VirtualNodeRef.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getVirtualNodes: ZIO[Any, Nothing, List[
      zio.aws.appmesh.model.VirtualNodeRef.ReadOnly
    ]] = ZIO.succeed(virtualNodes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse
  ) extends zio.aws.appmesh.model.ListVirtualNodesResponse.ReadOnly {
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
    override val virtualNodes
        : List[zio.aws.appmesh.model.VirtualNodeRef.ReadOnly] = impl
      .virtualNodes()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.VirtualNodeRef.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListVirtualNodesResponse
  ): zio.aws.appmesh.model.ListVirtualNodesResponse.ReadOnly = new Wrapper(impl)
}
