package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListMeshesResponse(
    meshes: Iterable[zio.aws.appmesh.model.MeshRef],
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListMeshesResponse = {
    import ListMeshesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListMeshesResponse
      .builder()
      .meshes(meshes.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListMeshesResponse.ReadOnly =
    zio.aws.appmesh.model.ListMeshesResponse.wrap(buildAwsValue())
}
object ListMeshesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListMeshesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListMeshesResponse =
      zio.aws.appmesh.model.ListMeshesResponse(
        meshes.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def meshes: List[zio.aws.appmesh.model.MeshRef.ReadOnly]
    def nextToken: Optional[String]
    def getMeshes
        : ZIO[Any, Nothing, List[zio.aws.appmesh.model.MeshRef.ReadOnly]] =
      ZIO.succeed(meshes)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListMeshesResponse
  ) extends zio.aws.appmesh.model.ListMeshesResponse.ReadOnly {
    override val meshes: List[zio.aws.appmesh.model.MeshRef.ReadOnly] = impl
      .meshes()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.MeshRef.wrap(item)
      }
      .toList
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListMeshesResponse
  ): zio.aws.appmesh.model.ListMeshesResponse.ReadOnly = new Wrapper(impl)
}
