package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GatewayRouteTarget(
    virtualService: zio.aws.appmesh.model.GatewayRouteVirtualService
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GatewayRouteTarget = {
    import GatewayRouteTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GatewayRouteTarget
      .builder()
      .virtualService(virtualService.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly =
    zio.aws.appmesh.model.GatewayRouteTarget.wrap(buildAwsValue())
}
object GatewayRouteTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GatewayRouteTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GatewayRouteTarget =
      zio.aws.appmesh.model.GatewayRouteTarget(virtualService.asEditable)
    def virtualService
        : zio.aws.appmesh.model.GatewayRouteVirtualService.ReadOnly
    def getVirtualService: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.GatewayRouteVirtualService.ReadOnly
    ] = ZIO.succeed(virtualService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteTarget
  ) extends zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly {
    override val virtualService
        : zio.aws.appmesh.model.GatewayRouteVirtualService.ReadOnly =
      zio.aws.appmesh.model.GatewayRouteVirtualService
        .wrap(impl.virtualService())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteTarget
  ): zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly = new Wrapper(impl)
}
