package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class TcpTimeout(
    idle: Optional[zio.aws.appmesh.model.Duration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.TcpTimeout = {
    import TcpTimeout.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.TcpTimeout
      .builder()
      .optionallyWith(idle.map(value => value.buildAwsValue()))(_.idle)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.TcpTimeout.ReadOnly =
    zio.aws.appmesh.model.TcpTimeout.wrap(buildAwsValue())
}
object TcpTimeout {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.TcpTimeout
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.TcpTimeout =
      zio.aws.appmesh.model.TcpTimeout(idle.map(value => value.asEditable))
    def idle: Optional[zio.aws.appmesh.model.Duration.ReadOnly]
    def getIdle: ZIO[Any, AwsError, zio.aws.appmesh.model.Duration.ReadOnly] =
      AwsError.unwrapOptionField("idle", idle)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.TcpTimeout
  ) extends zio.aws.appmesh.model.TcpTimeout.ReadOnly {
    override val idle: Optional[zio.aws.appmesh.model.Duration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.idle())
        .map(value => zio.aws.appmesh.model.Duration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.TcpTimeout
  ): zio.aws.appmesh.model.TcpTimeout.ReadOnly = new Wrapper(impl)
}
