package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VirtualServiceProvider(
    virtualNode: Optional[zio.aws.appmesh.model.VirtualNodeServiceProvider] =
      Optional.Absent,
    virtualRouter: Optional[
      zio.aws.appmesh.model.VirtualRouterServiceProvider
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualServiceProvider = {
    import VirtualServiceProvider.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualServiceProvider
      .builder()
      .optionallyWith(virtualNode.map(value => value.buildAwsValue()))(
        _.virtualNode
      )
      .optionallyWith(virtualRouter.map(value => value.buildAwsValue()))(
        _.virtualRouter
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualServiceProvider.ReadOnly =
    zio.aws.appmesh.model.VirtualServiceProvider.wrap(buildAwsValue())
}
object VirtualServiceProvider {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualServiceProvider
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualServiceProvider =
      zio.aws.appmesh.model.VirtualServiceProvider(
        virtualNode.map(value => value.asEditable),
        virtualRouter.map(value => value.asEditable)
      )
    def virtualNode
        : Optional[zio.aws.appmesh.model.VirtualNodeServiceProvider.ReadOnly]
    def virtualRouter
        : Optional[zio.aws.appmesh.model.VirtualRouterServiceProvider.ReadOnly]
    def getVirtualNode: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualNodeServiceProvider.ReadOnly
    ] = AwsError.unwrapOptionField("virtualNode", virtualNode)
    def getVirtualRouter: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualRouterServiceProvider.ReadOnly
    ] = AwsError.unwrapOptionField("virtualRouter", virtualRouter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceProvider
  ) extends zio.aws.appmesh.model.VirtualServiceProvider.ReadOnly {
    override val virtualNode
        : Optional[zio.aws.appmesh.model.VirtualNodeServiceProvider.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualNode())
        .map(value =>
          zio.aws.appmesh.model.VirtualNodeServiceProvider.wrap(value)
        )
    override val virtualRouter: Optional[
      zio.aws.appmesh.model.VirtualRouterServiceProvider.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.virtualRouter())
      .map(value =>
        zio.aws.appmesh.model.VirtualRouterServiceProvider.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceProvider
  ): zio.aws.appmesh.model.VirtualServiceProvider.ReadOnly = new Wrapper(impl)
}
