package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VirtualGatewayClientTlsCertificate(
    file: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate
    ] = Optional.Absent,
    sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientTlsCertificate = {
    import VirtualGatewayClientTlsCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientTlsCertificate
      .builder()
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate
      .wrap(buildAwsValue())
}
object VirtualGatewayClientTlsCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientTlsCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate =
      zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate(
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def file: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate.ReadOnly
    ]
    def sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate.ReadOnly
    ]
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientTlsCertificate
  ) extends zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate.ReadOnly {
    override val file: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.file())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayListenerTlsFileCertificate
          .wrap(value)
      )
    override val sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sds())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayListenerTlsSdsCertificate
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayClientTlsCertificate
  ): zio.aws.appmesh.model.VirtualGatewayClientTlsCertificate.ReadOnly =
    new Wrapper(impl)
}
