package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class VirtualGatewayTlsValidationContextTrust(
    acm: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust
    ] = Optional.Absent,
    file: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
    ] = Optional.Absent,
    sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextTrust = {
    import VirtualGatewayTlsValidationContextTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextTrust
      .builder()
      .optionallyWith(acm.map(value => value.buildAwsValue()))(_.acm)
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust
      .wrap(buildAwsValue())
}
object VirtualGatewayTlsValidationContextTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust =
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust(
        acm.map(value => value.asEditable),
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def acm: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust.ReadOnly
    ]
    def file: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ]
    def sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ]
    def getAcm: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust.ReadOnly
    ] = AwsError.unwrapOptionField("acm", acm)
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextTrust
  ) extends zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust.ReadOnly {
    override val acm: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acm())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust
          .wrap(value)
      )
    override val file: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.file())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
          .wrap(value)
      )
    override val sds: Optional[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sds())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextTrust
  ): zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust.ReadOnly =
    new Wrapper(impl)
}
