package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateMeshResponse(mesh: zio.aws.appmesh.model.MeshData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.CreateMeshResponse = {
    import CreateMeshResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.CreateMeshResponse
      .builder()
      .mesh(mesh.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.CreateMeshResponse.ReadOnly =
    zio.aws.appmesh.model.CreateMeshResponse.wrap(buildAwsValue())
}
object CreateMeshResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.CreateMeshResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.CreateMeshResponse =
      zio.aws.appmesh.model.CreateMeshResponse(mesh.asEditable)
    def mesh: zio.aws.appmesh.model.MeshData.ReadOnly
    def getMesh: ZIO[Any, Nothing, zio.aws.appmesh.model.MeshData.ReadOnly] =
      ZIO.succeed(mesh)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.CreateMeshResponse
  ) extends zio.aws.appmesh.model.CreateMeshResponse.ReadOnly {
    override val mesh: zio.aws.appmesh.model.MeshData.ReadOnly =
      zio.aws.appmesh.model.MeshData.wrap(impl.mesh())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.CreateMeshResponse
  ): zio.aws.appmesh.model.CreateMeshResponse.ReadOnly = new Wrapper(impl)
}
