package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.appmesh.model.primitives.ServiceName
import scala.jdk.CollectionConverters._
final case class VirtualServiceBackend(
    clientPolicy: Optional[zio.aws.appmesh.model.ClientPolicy] =
      Optional.Absent,
    virtualServiceName: ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualServiceBackend = {
    import VirtualServiceBackend.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualServiceBackend
      .builder()
      .optionallyWith(clientPolicy.map(value => value.buildAwsValue()))(
        _.clientPolicy
      )
      .virtualServiceName(
        ServiceName.unwrap(virtualServiceName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualServiceBackend.ReadOnly =
    zio.aws.appmesh.model.VirtualServiceBackend.wrap(buildAwsValue())
}
object VirtualServiceBackend {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualServiceBackend
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualServiceBackend =
      zio.aws.appmesh.model.VirtualServiceBackend(
        clientPolicy.map(value => value.asEditable),
        virtualServiceName
      )
    def clientPolicy: Optional[zio.aws.appmesh.model.ClientPolicy.ReadOnly]
    def virtualServiceName: ServiceName
    def getClientPolicy
        : ZIO[Any, AwsError, zio.aws.appmesh.model.ClientPolicy.ReadOnly] =
      AwsError.unwrapOptionField("clientPolicy", clientPolicy)
    def getVirtualServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(virtualServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceBackend
  ) extends zio.aws.appmesh.model.VirtualServiceBackend.ReadOnly {
    override val clientPolicy
        : Optional[zio.aws.appmesh.model.ClientPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientPolicy())
        .map(value => zio.aws.appmesh.model.ClientPolicy.wrap(value))
    override val virtualServiceName: ServiceName =
      zio.aws.appmesh.model.primitives.ServiceName(impl.virtualServiceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualServiceBackend
  ): zio.aws.appmesh.model.VirtualServiceBackend.ReadOnly = new Wrapper(impl)
}
