package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ClientPolicy(
    tls: Optional[zio.aws.appmesh.model.ClientPolicyTls] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ClientPolicy = {
    import ClientPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ClientPolicy
      .builder()
      .optionallyWith(tls.map(value => value.buildAwsValue()))(_.tls)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ClientPolicy.ReadOnly =
    zio.aws.appmesh.model.ClientPolicy.wrap(buildAwsValue())
}
object ClientPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ClientPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ClientPolicy =
      zio.aws.appmesh.model.ClientPolicy(tls.map(value => value.asEditable))
    def tls: Optional[zio.aws.appmesh.model.ClientPolicyTls.ReadOnly]
    def getTls
        : ZIO[Any, AwsError, zio.aws.appmesh.model.ClientPolicyTls.ReadOnly] =
      AwsError.unwrapOptionField("tls", tls)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ClientPolicy
  ) extends zio.aws.appmesh.model.ClientPolicy.ReadOnly {
    override val tls: Optional[zio.aws.appmesh.model.ClientPolicyTls.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tls())
        .map(value => zio.aws.appmesh.model.ClientPolicyTls.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ClientPolicy
  ): zio.aws.appmesh.model.ClientPolicy.ReadOnly = new Wrapper(impl)
}
