package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MeshSpec(
    egressFilter: Optional[zio.aws.appmesh.model.EgressFilter] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.MeshSpec = {
    import MeshSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.MeshSpec
      .builder()
      .optionallyWith(egressFilter.map(value => value.buildAwsValue()))(
        _.egressFilter
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.MeshSpec.ReadOnly =
    zio.aws.appmesh.model.MeshSpec.wrap(buildAwsValue())
}
object MeshSpec {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.MeshSpec] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.MeshSpec = zio.aws.appmesh.model
      .MeshSpec(egressFilter.map(value => value.asEditable))
    def egressFilter: Optional[zio.aws.appmesh.model.EgressFilter.ReadOnly]
    def getEgressFilter
        : ZIO[Any, AwsError, zio.aws.appmesh.model.EgressFilter.ReadOnly] =
      AwsError.unwrapOptionField("egressFilter", egressFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.MeshSpec
  ) extends zio.aws.appmesh.model.MeshSpec.ReadOnly {
    override val egressFilter
        : Optional[zio.aws.appmesh.model.EgressFilter.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.egressFilter())
        .map(value => zio.aws.appmesh.model.EgressFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.MeshSpec
  ): zio.aws.appmesh.model.MeshSpec.ReadOnly = new Wrapper(impl)
}
