package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class VirtualNodeStatus(
    status: zio.aws.appmesh.model.VirtualNodeStatusCode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualNodeStatus = {
    import VirtualNodeStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualNodeStatus
      .builder()
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualNodeStatus.ReadOnly =
    zio.aws.appmesh.model.VirtualNodeStatus.wrap(buildAwsValue())
}
object VirtualNodeStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualNodeStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualNodeStatus =
      zio.aws.appmesh.model.VirtualNodeStatus(status)
    def status: zio.aws.appmesh.model.VirtualNodeStatusCode
    def getStatus
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualNodeStatusCode] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeStatus
  ) extends zio.aws.appmesh.model.VirtualNodeStatus.ReadOnly {
    override val status: zio.aws.appmesh.model.VirtualNodeStatusCode =
      zio.aws.appmesh.model.VirtualNodeStatusCode.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeStatus
  ): zio.aws.appmesh.model.VirtualNodeStatus.ReadOnly = new Wrapper(impl)
}
