package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.appmesh.model.primitives.{
  AccountId,
  ResourceName,
  Timestamp,
  Arn
}
import scala.jdk.CollectionConverters._
final case class RouteRef(
    arn: Arn,
    createdAt: Timestamp,
    lastUpdatedAt: Timestamp,
    meshName: ResourceName,
    meshOwner: AccountId,
    resourceOwner: AccountId,
    routeName: ResourceName,
    version: Long,
    virtualRouterName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.RouteRef = {
    import RouteRef.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.RouteRef
      .builder()
      .arn(Arn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .lastUpdatedAt(Timestamp.unwrap(lastUpdatedAt): Instant)
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .meshOwner(AccountId.unwrap(meshOwner): java.lang.String)
      .resourceOwner(AccountId.unwrap(resourceOwner): java.lang.String)
      .routeName(ResourceName.unwrap(routeName): java.lang.String)
      .version(version: java.lang.Long)
      .virtualRouterName(
        ResourceName.unwrap(virtualRouterName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.RouteRef.ReadOnly =
    zio.aws.appmesh.model.RouteRef.wrap(buildAwsValue())
}
object RouteRef {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.RouteRef] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.RouteRef =
      zio.aws.appmesh.model.RouteRef(
        arn,
        createdAt,
        lastUpdatedAt,
        meshName,
        meshOwner,
        resourceOwner,
        routeName,
        version,
        virtualRouterName
      )
    def arn: Arn
    def createdAt: Timestamp
    def lastUpdatedAt: Timestamp
    def meshName: ResourceName
    def meshOwner: AccountId
    def resourceOwner: AccountId
    def routeName: ResourceName
    def version: Long
    def virtualRouterName: ResourceName
    def getArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getLastUpdatedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastUpdatedAt)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, Nothing, AccountId] = ZIO.succeed(meshOwner)
    def getResourceOwner: ZIO[Any, Nothing, AccountId] =
      ZIO.succeed(resourceOwner)
    def getRouteName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(routeName)
    def getVersion: ZIO[Any, Nothing, Long] = ZIO.succeed(version)
    def getVirtualRouterName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(virtualRouterName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.RouteRef
  ) extends zio.aws.appmesh.model.RouteRef.ReadOnly {
    override val arn: Arn = zio.aws.appmesh.model.primitives.Arn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.createdAt())
    override val lastUpdatedAt: Timestamp =
      zio.aws.appmesh.model.primitives.Timestamp(impl.lastUpdatedAt())
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.meshOwner())
    override val resourceOwner: AccountId =
      zio.aws.appmesh.model.primitives.AccountId(impl.resourceOwner())
    override val routeName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.routeName())
    override val version: Long = impl.version(): Long
    override val virtualRouterName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.virtualRouterName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.RouteRef
  ): zio.aws.appmesh.model.RouteRef.ReadOnly = new Wrapper(impl)
}
