package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VirtualGatewayTlsValidationContext(
    subjectAlternativeNames: Option[
      zio.aws.appmesh.model.SubjectAlternativeNames
    ] = None,
    trust: zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContext = {
    import VirtualGatewayTlsValidationContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContext
      .builder()
      .optionallyWith(
        subjectAlternativeNames.map(value => value.buildAwsValue())
      )(_.subjectAlternativeNames)
      .trust(trust.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayTlsValidationContext.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayTlsValidationContext
      .wrap(buildAwsValue())
}
object VirtualGatewayTlsValidationContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayTlsValidationContext =
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContext(
        subjectAlternativeNames.map(value => value.asEditable),
        trust.asEditable
      )
    def subjectAlternativeNames
        : Option[zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly]
    def trust
        : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust.ReadOnly
    def getSubjectAlternativeNames: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly
    ] = AwsError.unwrapOptionField(
      "subjectAlternativeNames",
      subjectAlternativeNames
    )
    def getTrust: ZIO[
      Any,
      Nothing,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust.ReadOnly
    ] = ZIO.succeed(trust)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContext
  ) extends zio.aws.appmesh.model.VirtualGatewayTlsValidationContext.ReadOnly {
    override val subjectAlternativeNames
        : Option[zio.aws.appmesh.model.SubjectAlternativeNames.ReadOnly] = scala
      .Option(impl.subjectAlternativeNames())
      .map(value => zio.aws.appmesh.model.SubjectAlternativeNames.wrap(value))
    override val trust
        : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust.ReadOnly =
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust
        .wrap(impl.trust())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContext
  ): zio.aws.appmesh.model.VirtualGatewayTlsValidationContext.ReadOnly =
    new Wrapper(impl)
}
