package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VirtualGatewaySpec(
    backendDefaults: Option[
      zio.aws.appmesh.model.VirtualGatewayBackendDefaults
    ] = None,
    listeners: Iterable[zio.aws.appmesh.model.VirtualGatewayListener],
    logging: Option[zio.aws.appmesh.model.VirtualGatewayLogging] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewaySpec = {
    import VirtualGatewaySpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewaySpec
      .builder()
      .optionallyWith(backendDefaults.map(value => value.buildAwsValue()))(
        _.backendDefaults
      )
      .listeners(listeners.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewaySpec.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewaySpec.wrap(buildAwsValue())
}
object VirtualGatewaySpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewaySpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewaySpec =
      zio.aws.appmesh.model.VirtualGatewaySpec(
        backendDefaults.map(value => value.asEditable),
        listeners.map { item =>
          item.asEditable
        },
        logging.map(value => value.asEditable)
      )
    def backendDefaults
        : Option[zio.aws.appmesh.model.VirtualGatewayBackendDefaults.ReadOnly]
    def listeners: List[zio.aws.appmesh.model.VirtualGatewayListener.ReadOnly]
    def logging: Option[zio.aws.appmesh.model.VirtualGatewayLogging.ReadOnly]
    def getBackendDefaults: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayBackendDefaults.ReadOnly
    ] = AwsError.unwrapOptionField("backendDefaults", backendDefaults)
    def getListeners: ZIO[Any, Nothing, List[
      zio.aws.appmesh.model.VirtualGatewayListener.ReadOnly
    ]] = ZIO.succeed(listeners)
    def getLogging: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayLogging.ReadOnly
    ] = AwsError.unwrapOptionField("logging", logging)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewaySpec
  ) extends zio.aws.appmesh.model.VirtualGatewaySpec.ReadOnly {
    override val backendDefaults
        : Option[zio.aws.appmesh.model.VirtualGatewayBackendDefaults.ReadOnly] =
      scala
        .Option(impl.backendDefaults())
        .map(value =>
          zio.aws.appmesh.model.VirtualGatewayBackendDefaults.wrap(value)
        )
    override val listeners
        : List[zio.aws.appmesh.model.VirtualGatewayListener.ReadOnly] = impl
      .listeners()
      .asScala
      .map { item =>
        zio.aws.appmesh.model.VirtualGatewayListener.wrap(item)
      }
      .toList
    override val logging
        : Option[zio.aws.appmesh.model.VirtualGatewayLogging.ReadOnly] = scala
      .Option(impl.logging())
      .map(value => zio.aws.appmesh.model.VirtualGatewayLogging.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewaySpec
  ): zio.aws.appmesh.model.VirtualGatewaySpec.ReadOnly = new Wrapper(impl)
}
