package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{ServiceName, AccountId, ResourceName}
import scala.jdk.CollectionConverters._
final case class UpdateVirtualServiceRequest(
    clientToken: Option[String] = None,
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    spec: zio.aws.appmesh.model.VirtualServiceSpec,
    virtualServiceName: ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceRequest = {
    import UpdateVirtualServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceRequest
      .builder()
      .optionallyWith(clientToken.map(value => value: java.lang.String))(
        _.clientToken
      )
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .spec(spec.buildAwsValue())
      .virtualServiceName(
        ServiceName.unwrap(virtualServiceName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.UpdateVirtualServiceRequest.ReadOnly =
    zio.aws.appmesh.model.UpdateVirtualServiceRequest.wrap(buildAwsValue())
}
object UpdateVirtualServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.UpdateVirtualServiceRequest =
      zio.aws.appmesh.model.UpdateVirtualServiceRequest(
        clientToken.map(value => value),
        meshName,
        meshOwner.map(value => value),
        spec.asEditable,
        virtualServiceName
      )
    def clientToken: Option[String]
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def spec: zio.aws.appmesh.model.VirtualServiceSpec.ReadOnly
    def virtualServiceName: ServiceName
    def getClientToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getSpec
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualServiceSpec.ReadOnly] =
      ZIO.succeed(spec)
    def getVirtualServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(virtualServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceRequest
  ) extends zio.aws.appmesh.model.UpdateVirtualServiceRequest.ReadOnly {
    override val clientToken: Option[String] =
      scala.Option(impl.clientToken()).map(value => value: String)
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val spec: zio.aws.appmesh.model.VirtualServiceSpec.ReadOnly =
      zio.aws.appmesh.model.VirtualServiceSpec.wrap(impl.spec())
    override val virtualServiceName: ServiceName =
      zio.aws.appmesh.model.primitives.ServiceName(impl.virtualServiceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceRequest
  ): zio.aws.appmesh.model.UpdateVirtualServiceRequest.ReadOnly = new Wrapper(
    impl
  )
}
