package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VirtualGatewayConnectionPool(
    grpc: Option[zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool] = None,
    http: Option[zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool] = None,
    http2: Option[zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayConnectionPool = {
    import VirtualGatewayConnectionPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayConnectionPool
      .builder()
      .optionallyWith(grpc.map(value => value.buildAwsValue()))(_.grpc)
      .optionallyWith(http.map(value => value.buildAwsValue()))(_.http)
      .optionallyWith(http2.map(value => value.buildAwsValue()))(_.http2)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualGatewayConnectionPool.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayConnectionPool.wrap(buildAwsValue())
}
object VirtualGatewayConnectionPool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayConnectionPool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualGatewayConnectionPool =
      zio.aws.appmesh.model.VirtualGatewayConnectionPool(
        grpc.map(value => value.asEditable),
        http.map(value => value.asEditable),
        http2.map(value => value.asEditable)
      )
    def grpc: Option[
      zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.ReadOnly
    ]
    def http: Option[
      zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.ReadOnly
    ]
    def http2: Option[
      zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.ReadOnly
    ]
    def getGrpc: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("grpc", grpc)
    def getHttp: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("http", http)
    def getHttp2: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("http2", http2)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayConnectionPool
  ) extends zio.aws.appmesh.model.VirtualGatewayConnectionPool.ReadOnly {
    override val grpc: Option[
      zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.ReadOnly
    ] = scala
      .Option(impl.grpc())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayGrpcConnectionPool.wrap(value)
      )
    override val http: Option[
      zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.ReadOnly
    ] = scala
      .Option(impl.http())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayHttpConnectionPool.wrap(value)
      )
    override val http2: Option[
      zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.ReadOnly
    ] = scala
      .Option(impl.http2())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayHttp2ConnectionPool.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayConnectionPool
  ): zio.aws.appmesh.model.VirtualGatewayConnectionPool.ReadOnly = new Wrapper(
    impl
  )
}
