package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{AccountId, ResourceName}
import scala.jdk.CollectionConverters._
final case class DescribeMeshRequest(
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DescribeMeshRequest = {
    import DescribeMeshRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DescribeMeshRequest
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DescribeMeshRequest.ReadOnly =
    zio.aws.appmesh.model.DescribeMeshRequest.wrap(buildAwsValue())
}
object DescribeMeshRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DescribeMeshRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DescribeMeshRequest =
      zio.aws.appmesh.model
        .DescribeMeshRequest(meshName, meshOwner.map(value => value))
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeMeshRequest
  ) extends zio.aws.appmesh.model.DescribeMeshRequest.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DescribeMeshRequest
  ): zio.aws.appmesh.model.DescribeMeshRequest.ReadOnly = new Wrapper(impl)
}
