package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateVirtualServiceResponse(
    virtualService: zio.aws.appmesh.model.VirtualServiceData
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceResponse = {
    import UpdateVirtualServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceResponse
      .builder()
      .virtualService(virtualService.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.UpdateVirtualServiceResponse.ReadOnly =
    zio.aws.appmesh.model.UpdateVirtualServiceResponse.wrap(buildAwsValue())
}
object UpdateVirtualServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.UpdateVirtualServiceResponse =
      zio.aws.appmesh.model
        .UpdateVirtualServiceResponse(virtualService.asEditable)
    def virtualService: zio.aws.appmesh.model.VirtualServiceData.ReadOnly
    def getVirtualService
        : ZIO[Any, Nothing, zio.aws.appmesh.model.VirtualServiceData.ReadOnly] =
      ZIO.succeed(virtualService)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceResponse
  ) extends zio.aws.appmesh.model.UpdateVirtualServiceResponse.ReadOnly {
    override val virtualService
        : zio.aws.appmesh.model.VirtualServiceData.ReadOnly =
      zio.aws.appmesh.model.VirtualServiceData.wrap(impl.virtualService())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.UpdateVirtualServiceResponse
  ): zio.aws.appmesh.model.UpdateVirtualServiceResponse.ReadOnly = new Wrapper(
    impl
  )
}
