package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.ListMeshesLimit
import scala.jdk.CollectionConverters._
final case class ListMeshesRequest(
    limit: Option[ListMeshesLimit] = None,
    nextToken: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListMeshesRequest = {
    import ListMeshesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListMeshesRequest
      .builder()
      .optionallyWith(
        limit.map(value => ListMeshesLimit.unwrap(value): Integer)
      )(_.limit)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListMeshesRequest.ReadOnly =
    zio.aws.appmesh.model.ListMeshesRequest.wrap(buildAwsValue())
}
object ListMeshesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListMeshesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListMeshesRequest =
      zio.aws.appmesh.model.ListMeshesRequest(
        limit.map(value => value),
        nextToken.map(value => value)
      )
    def limit: Option[ListMeshesLimit]
    def nextToken: Option[String]
    def getLimit: ZIO[Any, AwsError, ListMeshesLimit] =
      AwsError.unwrapOptionField("limit", limit)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListMeshesRequest
  ) extends zio.aws.appmesh.model.ListMeshesRequest.ReadOnly {
    override val limit: Option[ListMeshesLimit] = scala
      .Option(impl.limit())
      .map(value => zio.aws.appmesh.model.primitives.ListMeshesLimit(value))
    override val nextToken: Option[String] =
      scala.Option(impl.nextToken()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListMeshesRequest
  ): zio.aws.appmesh.model.ListMeshesRequest.ReadOnly = new Wrapper(impl)
}
