package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HttpGatewayRouteRewrite(
    hostname: Option[zio.aws.appmesh.model.GatewayRouteHostnameRewrite] = None,
    path: Option[zio.aws.appmesh.model.HttpGatewayRoutePathRewrite] = None,
    prefix: Option[zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteRewrite = {
    import HttpGatewayRouteRewrite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteRewrite
      .builder()
      .optionallyWith(hostname.map(value => value.buildAwsValue()))(_.hostname)
      .optionallyWith(path.map(value => value.buildAwsValue()))(_.path)
      .optionallyWith(prefix.map(value => value.buildAwsValue()))(_.prefix)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpGatewayRouteRewrite.ReadOnly =
    zio.aws.appmesh.model.HttpGatewayRouteRewrite.wrap(buildAwsValue())
}
object HttpGatewayRouteRewrite {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteRewrite
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpGatewayRouteRewrite =
      zio.aws.appmesh.model.HttpGatewayRouteRewrite(
        hostname.map(value => value.asEditable),
        path.map(value => value.asEditable),
        prefix.map(value => value.asEditable)
      )
    def hostname
        : Option[zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly]
    def path: Option[zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.ReadOnly]
    def prefix
        : Option[zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.ReadOnly]
    def getHostname: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly
    ] = AwsError.unwrapOptionField("hostname", hostname)
    def getPath: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.ReadOnly
    ] = AwsError.unwrapOptionField("path", path)
    def getPrefix: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.ReadOnly
    ] = AwsError.unwrapOptionField("prefix", prefix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteRewrite
  ) extends zio.aws.appmesh.model.HttpGatewayRouteRewrite.ReadOnly {
    override val hostname
        : Option[zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly] =
      scala
        .Option(impl.hostname())
        .map(value =>
          zio.aws.appmesh.model.GatewayRouteHostnameRewrite.wrap(value)
        )
    override val path
        : Option[zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.ReadOnly] =
      scala
        .Option(impl.path())
        .map(value =>
          zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.wrap(value)
        )
    override val prefix
        : Option[zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.ReadOnly] =
      scala
        .Option(impl.prefix())
        .map(value =>
          zio.aws.appmesh.model.HttpGatewayRoutePrefixRewrite.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteRewrite
  ): zio.aws.appmesh.model.HttpGatewayRouteRewrite.ReadOnly = new Wrapper(impl)
}
