package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.{ServiceName, AccountId, ResourceName}
import scala.jdk.CollectionConverters._
final case class DeleteVirtualServiceRequest(
    meshName: ResourceName,
    meshOwner: Option[AccountId] = None,
    virtualServiceName: ServiceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceRequest = {
    import DeleteVirtualServiceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceRequest
      .builder()
      .meshName(ResourceName.unwrap(meshName): java.lang.String)
      .optionallyWith(
        meshOwner.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.meshOwner)
      .virtualServiceName(
        ServiceName.unwrap(virtualServiceName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.DeleteVirtualServiceRequest.ReadOnly =
    zio.aws.appmesh.model.DeleteVirtualServiceRequest.wrap(buildAwsValue())
}
object DeleteVirtualServiceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.DeleteVirtualServiceRequest =
      zio.aws.appmesh.model.DeleteVirtualServiceRequest(
        meshName,
        meshOwner.map(value => value),
        virtualServiceName
      )
    def meshName: ResourceName
    def meshOwner: Option[AccountId]
    def virtualServiceName: ServiceName
    def getMeshName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(meshName)
    def getMeshOwner: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("meshOwner", meshOwner)
    def getVirtualServiceName: ZIO[Any, Nothing, ServiceName] =
      ZIO.succeed(virtualServiceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceRequest
  ) extends zio.aws.appmesh.model.DeleteVirtualServiceRequest.ReadOnly {
    override val meshName: ResourceName =
      zio.aws.appmesh.model.primitives.ResourceName(impl.meshName())
    override val meshOwner: Option[AccountId] = scala
      .Option(impl.meshOwner())
      .map(value => zio.aws.appmesh.model.primitives.AccountId(value))
    override val virtualServiceName: ServiceName =
      zio.aws.appmesh.model.primitives.ServiceName(impl.virtualServiceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.DeleteVirtualServiceRequest
  ): zio.aws.appmesh.model.DeleteVirtualServiceRequest.ReadOnly = new Wrapper(
    impl
  )
}
