package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VirtualNodeConnectionPool(
    grpc: Option[zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool] = None,
    http: Option[zio.aws.appmesh.model.VirtualNodeHttpConnectionPool] = None,
    http2: Option[zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool] = None,
    tcp: Option[zio.aws.appmesh.model.VirtualNodeTcpConnectionPool] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualNodeConnectionPool = {
    import VirtualNodeConnectionPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualNodeConnectionPool
      .builder()
      .optionallyWith(grpc.map(value => value.buildAwsValue()))(_.grpc)
      .optionallyWith(http.map(value => value.buildAwsValue()))(_.http)
      .optionallyWith(http2.map(value => value.buildAwsValue()))(_.http2)
      .optionallyWith(tcp.map(value => value.buildAwsValue()))(_.tcp)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualNodeConnectionPool.ReadOnly =
    zio.aws.appmesh.model.VirtualNodeConnectionPool.wrap(buildAwsValue())
}
object VirtualNodeConnectionPool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualNodeConnectionPool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualNodeConnectionPool =
      zio.aws.appmesh.model.VirtualNodeConnectionPool(
        grpc.map(value => value.asEditable),
        http.map(value => value.asEditable),
        http2.map(value => value.asEditable),
        tcp.map(value => value.asEditable)
      )
    def grpc
        : Option[zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool.ReadOnly]
    def http
        : Option[zio.aws.appmesh.model.VirtualNodeHttpConnectionPool.ReadOnly]
    def http2
        : Option[zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool.ReadOnly]
    def tcp: Option[zio.aws.appmesh.model.VirtualNodeTcpConnectionPool.ReadOnly]
    def getGrpc: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("grpc", grpc)
    def getHttp: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualNodeHttpConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("http", http)
    def getHttp2: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("http2", http2)
    def getTcp: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualNodeTcpConnectionPool.ReadOnly
    ] = AwsError.unwrapOptionField("tcp", tcp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeConnectionPool
  ) extends zio.aws.appmesh.model.VirtualNodeConnectionPool.ReadOnly {
    override val grpc
        : Option[zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool.ReadOnly] =
      scala
        .Option(impl.grpc())
        .map(value =>
          zio.aws.appmesh.model.VirtualNodeGrpcConnectionPool.wrap(value)
        )
    override val http
        : Option[zio.aws.appmesh.model.VirtualNodeHttpConnectionPool.ReadOnly] =
      scala
        .Option(impl.http())
        .map(value =>
          zio.aws.appmesh.model.VirtualNodeHttpConnectionPool.wrap(value)
        )
    override val http2: Option[
      zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool.ReadOnly
    ] = scala
      .Option(impl.http2())
      .map(value =>
        zio.aws.appmesh.model.VirtualNodeHttp2ConnectionPool.wrap(value)
      )
    override val tcp
        : Option[zio.aws.appmesh.model.VirtualNodeTcpConnectionPool.ReadOnly] =
      scala
        .Option(impl.tcp())
        .map(value =>
          zio.aws.appmesh.model.VirtualNodeTcpConnectionPool.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeConnectionPool
  ): zio.aws.appmesh.model.VirtualNodeConnectionPool.ReadOnly = new Wrapper(
    impl
  )
}
