package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.appmesh.model.primitives.FilePath
import scala.jdk.CollectionConverters._
final case class ListenerTlsFileCertificate(
    certificateChain: FilePath,
    privateKey: FilePath
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ListenerTlsFileCertificate = {
    import ListenerTlsFileCertificate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ListenerTlsFileCertificate
      .builder()
      .certificateChain(FilePath.unwrap(certificateChain): java.lang.String)
      .privateKey(FilePath.unwrap(privateKey): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly =
    zio.aws.appmesh.model.ListenerTlsFileCertificate.wrap(buildAwsValue())
}
object ListenerTlsFileCertificate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ListenerTlsFileCertificate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ListenerTlsFileCertificate =
      zio.aws.appmesh.model
        .ListenerTlsFileCertificate(certificateChain, privateKey)
    def certificateChain: FilePath
    def privateKey: FilePath
    def getCertificateChain: ZIO[Any, Nothing, FilePath] =
      ZIO.succeed(certificateChain)
    def getPrivateKey: ZIO[Any, Nothing, FilePath] = ZIO.succeed(privateKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsFileCertificate
  ) extends zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly {
    override val certificateChain: FilePath =
      zio.aws.appmesh.model.primitives.FilePath(impl.certificateChain())
    override val privateKey: FilePath =
      zio.aws.appmesh.model.primitives.FilePath(impl.privateKey())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ListenerTlsFileCertificate
  ): zio.aws.appmesh.model.ListenerTlsFileCertificate.ReadOnly = new Wrapper(
    impl
  )
}
