package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.HttpPathExact
import scala.jdk.CollectionConverters._
final case class HttpGatewayRoutePathRewrite(
    exact: Option[HttpPathExact] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpGatewayRoutePathRewrite = {
    import HttpGatewayRoutePathRewrite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRoutePathRewrite
      .builder()
      .optionallyWith(
        exact.map(value => HttpPathExact.unwrap(value): java.lang.String)
      )(_.exact)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.ReadOnly =
    zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.wrap(buildAwsValue())
}
object HttpGatewayRoutePathRewrite {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRoutePathRewrite
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpGatewayRoutePathRewrite =
      zio.aws.appmesh.model
        .HttpGatewayRoutePathRewrite(exact.map(value => value))
    def exact: Option[HttpPathExact]
    def getExact: ZIO[Any, AwsError, HttpPathExact] =
      AwsError.unwrapOptionField("exact", exact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRoutePathRewrite
  ) extends zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.ReadOnly {
    override val exact: Option[HttpPathExact] = scala
      .Option(impl.exact())
      .map(value => zio.aws.appmesh.model.primitives.HttpPathExact(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRoutePathRewrite
  ): zio.aws.appmesh.model.HttpGatewayRoutePathRewrite.ReadOnly = new Wrapper(
    impl
  )
}
