package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HttpGatewayRouteAction(
    rewrite: Option[zio.aws.appmesh.model.HttpGatewayRouteRewrite] = None,
    target: zio.aws.appmesh.model.GatewayRouteTarget
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteAction = {
    import HttpGatewayRouteAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteAction
      .builder()
      .optionallyWith(rewrite.map(value => value.buildAwsValue()))(_.rewrite)
      .target(target.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpGatewayRouteAction.ReadOnly =
    zio.aws.appmesh.model.HttpGatewayRouteAction.wrap(buildAwsValue())
}
object HttpGatewayRouteAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpGatewayRouteAction =
      zio.aws.appmesh.model.HttpGatewayRouteAction(
        rewrite.map(value => value.asEditable),
        target.asEditable
      )
    def rewrite: Option[zio.aws.appmesh.model.HttpGatewayRouteRewrite.ReadOnly]
    def target: zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly
    def getRewrite: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.HttpGatewayRouteRewrite.ReadOnly
    ] = AwsError.unwrapOptionField("rewrite", rewrite)
    def getTarget
        : ZIO[Any, Nothing, zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly] =
      ZIO.succeed(target)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteAction
  ) extends zio.aws.appmesh.model.HttpGatewayRouteAction.ReadOnly {
    override val rewrite
        : Option[zio.aws.appmesh.model.HttpGatewayRouteRewrite.ReadOnly] = scala
      .Option(impl.rewrite())
      .map(value => zio.aws.appmesh.model.HttpGatewayRouteRewrite.wrap(value))
    override val target: zio.aws.appmesh.model.GatewayRouteTarget.ReadOnly =
      zio.aws.appmesh.model.GatewayRouteTarget.wrap(impl.target())
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpGatewayRouteAction
  ): zio.aws.appmesh.model.HttpGatewayRouteAction.ReadOnly = new Wrapper(impl)
}
