package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VirtualGatewayTlsValidationContextTrust(
    acm: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust
    ] = None,
    file: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
    ] = None,
    sds: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextTrust = {
    import VirtualGatewayTlsValidationContextTrust.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextTrust
      .builder()
      .optionallyWith(acm.map(value => value.buildAwsValue()))(_.acm)
      .optionallyWith(file.map(value => value.buildAwsValue()))(_.file)
      .optionallyWith(sds.map(value => value.buildAwsValue()))(_.sds)
      .build()
  }
  def asReadOnly
      : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust.ReadOnly =
    zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust
      .wrap(buildAwsValue())
}
object VirtualGatewayTlsValidationContextTrust {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextTrust
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust =
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust(
        acm.map(value => value.asEditable),
        file.map(value => value.asEditable),
        sds.map(value => value.asEditable)
      )
    def acm: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust.ReadOnly
    ]
    def file: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ]
    def sds: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ]
    def getAcm: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust.ReadOnly
    ] = AwsError.unwrapOptionField("acm", acm)
    def getFile: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ] = AwsError.unwrapOptionField("file", file)
    def getSds: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ] = AwsError.unwrapOptionField("sds", sds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextTrust
  ) extends zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust.ReadOnly {
    override val acm: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust.ReadOnly
    ] = scala
      .Option(impl.acm())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayTlsValidationContextAcmTrust
          .wrap(value)
      )
    override val file: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust.ReadOnly
    ] = scala
      .Option(impl.file())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayTlsValidationContextFileTrust
          .wrap(value)
      )
    override val sds: Option[
      zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust.ReadOnly
    ] = scala
      .Option(impl.sds())
      .map(value =>
        zio.aws.appmesh.model.VirtualGatewayTlsValidationContextSdsTrust
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualGatewayTlsValidationContextTrust
  ): zio.aws.appmesh.model.VirtualGatewayTlsValidationContextTrust.ReadOnly =
    new Wrapper(impl)
}
