package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class HttpRoute(
    action: zio.aws.appmesh.model.HttpRouteAction,
    `match`: zio.aws.appmesh.model.HttpRouteMatch,
    retryPolicy: Option[zio.aws.appmesh.model.HttpRetryPolicy] = None,
    timeout: Option[zio.aws.appmesh.model.HttpTimeout] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.HttpRoute = {
    import HttpRoute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.HttpRoute
      .builder()
      .action(action.buildAwsValue())
      .`match`(`match`.buildAwsValue())
      .optionallyWith(retryPolicy.map(value => value.buildAwsValue()))(
        _.retryPolicy
      )
      .optionallyWith(timeout.map(value => value.buildAwsValue()))(_.timeout)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.HttpRoute.ReadOnly =
    zio.aws.appmesh.model.HttpRoute.wrap(buildAwsValue())
}
object HttpRoute {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.HttpRoute] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.HttpRoute =
      zio.aws.appmesh.model.HttpRoute(
        action.asEditable,
        `match`.asEditable,
        retryPolicy.map(value => value.asEditable),
        timeout.map(value => value.asEditable)
      )
    def action: zio.aws.appmesh.model.HttpRouteAction.ReadOnly
    def `match`: zio.aws.appmesh.model.HttpRouteMatch.ReadOnly
    def retryPolicy: Option[zio.aws.appmesh.model.HttpRetryPolicy.ReadOnly]
    def timeout: Option[zio.aws.appmesh.model.HttpTimeout.ReadOnly]
    def getAction
        : ZIO[Any, Nothing, zio.aws.appmesh.model.HttpRouteAction.ReadOnly] =
      ZIO.succeed(action)
    def getMatch
        : ZIO[Any, Nothing, zio.aws.appmesh.model.HttpRouteMatch.ReadOnly] =
      ZIO.succeed(`match`)
    def getRetryPolicy
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpRetryPolicy.ReadOnly] =
      AwsError.unwrapOptionField("retryPolicy", retryPolicy)
    def getTimeout
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpTimeout.ReadOnly] =
      AwsError.unwrapOptionField("timeout", timeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRoute
  ) extends zio.aws.appmesh.model.HttpRoute.ReadOnly {
    override val action: zio.aws.appmesh.model.HttpRouteAction.ReadOnly =
      zio.aws.appmesh.model.HttpRouteAction.wrap(impl.action())
    override val `match`: zio.aws.appmesh.model.HttpRouteMatch.ReadOnly =
      zio.aws.appmesh.model.HttpRouteMatch.wrap(impl.`match`())
    override val retryPolicy
        : Option[zio.aws.appmesh.model.HttpRetryPolicy.ReadOnly] = scala
      .Option(impl.retryPolicy())
      .map(value => zio.aws.appmesh.model.HttpRetryPolicy.wrap(value))
    override val timeout: Option[zio.aws.appmesh.model.HttpTimeout.ReadOnly] =
      scala
        .Option(impl.timeout())
        .map(value => zio.aws.appmesh.model.HttpTimeout.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.HttpRoute
  ): zio.aws.appmesh.model.HttpRoute.ReadOnly = new Wrapper(impl)
}
