package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GatewayRouteHostnameRewrite(
    defaultTargetHostname: Option[
      zio.aws.appmesh.model.DefaultGatewayRouteRewrite
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameRewrite = {
    import GatewayRouteHostnameRewrite.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameRewrite
      .builder()
      .optionallyWith(defaultTargetHostname.map(value => value.unwrap))(
        _.defaultTargetHostname
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly =
    zio.aws.appmesh.model.GatewayRouteHostnameRewrite.wrap(buildAwsValue())
}
object GatewayRouteHostnameRewrite {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameRewrite
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.GatewayRouteHostnameRewrite =
      zio.aws.appmesh.model
        .GatewayRouteHostnameRewrite(defaultTargetHostname.map(value => value))
    def defaultTargetHostname
        : Option[zio.aws.appmesh.model.DefaultGatewayRouteRewrite]
    def getDefaultTargetHostname
        : ZIO[Any, AwsError, zio.aws.appmesh.model.DefaultGatewayRouteRewrite] =
      AwsError.unwrapOptionField("defaultTargetHostname", defaultTargetHostname)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameRewrite
  ) extends zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly {
    override val defaultTargetHostname
        : Option[zio.aws.appmesh.model.DefaultGatewayRouteRewrite] = scala
      .Option(impl.defaultTargetHostname())
      .map(value =>
        zio.aws.appmesh.model.DefaultGatewayRouteRewrite.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.GatewayRouteHostnameRewrite
  ): zio.aws.appmesh.model.GatewayRouteHostnameRewrite.ReadOnly = new Wrapper(
    impl
  )
}
