package zio.aws.appmesh
import zio.aws.appmesh.model.UpdateVirtualServiceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.appmesh.paginators.{
  ListVirtualNodesPublisher,
  ListVirtualServicesPublisher,
  ListVirtualRoutersPublisher,
  ListGatewayRoutesPublisher,
  ListTagsForResourcePublisher,
  ListVirtualGatewaysPublisher,
  ListMeshesPublisher,
  ListRoutesPublisher
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.appmesh.{
  AppMeshAsyncClientBuilder,
  AppMeshAsyncClient
}
import software.amazon.awssdk.services.appmesh.model.{
  UpdateMeshRequest,
  DescribeVirtualRouterRequest,
  DeleteRouteResponse,
  MeshRef,
  UpdateVirtualGatewayRequest,
  DeleteRouteRequest,
  UpdateVirtualNodeRequest,
  UpdateVirtualServiceResponse,
  UpdateVirtualNodeResponse,
  ListRoutesRequest,
  DescribeVirtualNodeRequest,
  CreateMeshRequest,
  ListVirtualServicesRequest,
  UpdateVirtualRouterRequest,
  ListRoutesResponse,
  DeleteMeshResponse,
  ListVirtualGatewaysResponse,
  ListGatewayRoutesResponse,
  UpdateGatewayRouteResponse,
  GatewayRouteRef,
  CreateGatewayRouteRequest,
  DeleteVirtualRouterRequest,
  ListVirtualNodesRequest,
  CreateVirtualServiceRequest,
  CreateRouteResponse,
  VirtualRouterRef,
  DeleteVirtualServiceRequest,
  DeleteVirtualGatewayRequest,
  DescribeVirtualRouterResponse,
  ListTagsForResourceRequest,
  DeleteMeshRequest,
  UpdateVirtualGatewayResponse,
  CreateRouteRequest,
  VirtualNodeRef,
  UpdateMeshResponse,
  ListVirtualRoutersResponse,
  DescribeVirtualGatewayRequest,
  DescribeVirtualGatewayResponse,
  ListTagsForResourceResponse,
  VirtualGatewayRef,
  DeleteVirtualRouterResponse,
  UntagResourceResponse,
  UpdateGatewayRouteRequest,
  UpdateVirtualServiceRequest,
  ListVirtualNodesResponse,
  ListMeshesRequest,
  DeleteVirtualNodeRequest,
  CreateVirtualGatewayResponse,
  DescribeGatewayRouteRequest,
  UpdateRouteRequest,
  DescribeVirtualServiceRequest,
  CreateVirtualNodeRequest,
  DescribeRouteRequest,
  ListGatewayRoutesRequest,
  UntagResourceRequest,
  DeleteVirtualGatewayResponse,
  ListVirtualGatewaysRequest,
  CreateVirtualNodeResponse,
  DeleteVirtualNodeResponse,
  ListVirtualRoutersRequest,
  RouteRef,
  DescribeVirtualNodeResponse,
  CreateGatewayRouteResponse,
  DescribeGatewayRouteResponse,
  DescribeRouteResponse,
  CreateVirtualServiceResponse,
  CreateVirtualRouterResponse,
  TagRef,
  ListMeshesResponse,
  DeleteVirtualServiceResponse,
  TagResourceResponse,
  DescribeMeshRequest,
  CreateVirtualGatewayRequest,
  ListVirtualServicesResponse,
  CreateVirtualRouterRequest,
  DescribeMeshResponse,
  DeleteGatewayRouteResponse,
  DescribeVirtualServiceResponse,
  TagResourceRequest,
  VirtualServiceRef,
  UpdateVirtualRouterResponse,
  CreateMeshResponse,
  DeleteGatewayRouteRequest,
  UpdateRouteResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait AppMesh extends AspectSupport[AppMesh] {
  val api: AppMeshAsyncClient
  def describeRoute(
      request: zio.aws.appmesh.model.DescribeRouteRequest
  ): IO[AwsError, zio.aws.appmesh.model.DescribeRouteResponse.ReadOnly]
  def createVirtualNode(
      request: zio.aws.appmesh.model.CreateVirtualNodeRequest
  ): IO[AwsError, zio.aws.appmesh.model.CreateVirtualNodeResponse.ReadOnly]
  def listGatewayRoutes(
      request: zio.aws.appmesh.model.ListGatewayRoutesRequest
  ): ZStream[Any, AwsError, zio.aws.appmesh.model.GatewayRouteRef.ReadOnly]
  def listGatewayRoutesPaginated(
      request: zio.aws.appmesh.model.ListGatewayRoutesRequest
  ): IO[AwsError, zio.aws.appmesh.model.ListGatewayRoutesResponse.ReadOnly]
  def createRoute(
      request: zio.aws.appmesh.model.CreateRouteRequest
  ): IO[AwsError, zio.aws.appmesh.model.CreateRouteResponse.ReadOnly]
  def deleteRoute(
      request: zio.aws.appmesh.model.DeleteRouteRequest
  ): IO[AwsError, zio.aws.appmesh.model.DeleteRouteResponse.ReadOnly]
  def updateGatewayRoute(
      request: zio.aws.appmesh.model.UpdateGatewayRouteRequest
  ): IO[AwsError, zio.aws.appmesh.model.UpdateGatewayRouteResponse.ReadOnly]
  def listVirtualGateways(
      request: zio.aws.appmesh.model.ListVirtualGatewaysRequest
  ): ZStream[Any, AwsError, zio.aws.appmesh.model.VirtualGatewayRef.ReadOnly]
  def listVirtualGatewaysPaginated(
      request: zio.aws.appmesh.model.ListVirtualGatewaysRequest
  ): IO[AwsError, zio.aws.appmesh.model.ListVirtualGatewaysResponse.ReadOnly]
  def updateRoute(
      request: zio.aws.appmesh.model.UpdateRouteRequest
  ): IO[AwsError, zio.aws.appmesh.model.UpdateRouteResponse.ReadOnly]
  def listVirtualRouters(
      request: zio.aws.appmesh.model.ListVirtualRoutersRequest
  ): ZStream[Any, AwsError, zio.aws.appmesh.model.VirtualRouterRef.ReadOnly]
  def listVirtualRoutersPaginated(
      request: zio.aws.appmesh.model.ListVirtualRoutersRequest
  ): IO[AwsError, zio.aws.appmesh.model.ListVirtualRoutersResponse.ReadOnly]
  def describeGatewayRoute(
      request: zio.aws.appmesh.model.DescribeGatewayRouteRequest
  ): IO[AwsError, zio.aws.appmesh.model.DescribeGatewayRouteResponse.ReadOnly]
  def deleteVirtualGateway(
      request: zio.aws.appmesh.model.DeleteVirtualGatewayRequest
  ): IO[AwsError, zio.aws.appmesh.model.DeleteVirtualGatewayResponse.ReadOnly]
  def updateVirtualGateway(
      request: zio.aws.appmesh.model.UpdateVirtualGatewayRequest
  ): IO[AwsError, zio.aws.appmesh.model.UpdateVirtualGatewayResponse.ReadOnly]
  def listRoutes(
      request: zio.aws.appmesh.model.ListRoutesRequest
  ): ZStream[Any, AwsError, zio.aws.appmesh.model.RouteRef.ReadOnly]
  def listRoutesPaginated(
      request: zio.aws.appmesh.model.ListRoutesRequest
  ): IO[AwsError, zio.aws.appmesh.model.ListRoutesResponse.ReadOnly]
  def createVirtualRouter(
      request: zio.aws.appmesh.model.CreateVirtualRouterRequest
  ): IO[AwsError, zio.aws.appmesh.model.CreateVirtualRouterResponse.ReadOnly]
  def createVirtualService(
      request: zio.aws.appmesh.model.CreateVirtualServiceRequest
  ): IO[AwsError, zio.aws.appmesh.model.CreateVirtualServiceResponse.ReadOnly]
  def updateVirtualNode(
      request: zio.aws.appmesh.model.UpdateVirtualNodeRequest
  ): IO[AwsError, zio.aws.appmesh.model.UpdateVirtualNodeResponse.ReadOnly]
  def updateMesh(
      request: zio.aws.appmesh.model.UpdateMeshRequest
  ): IO[AwsError, zio.aws.appmesh.model.UpdateMeshResponse.ReadOnly]
  def deleteVirtualService(
      request: zio.aws.appmesh.model.DeleteVirtualServiceRequest
  ): IO[AwsError, zio.aws.appmesh.model.DeleteVirtualServiceResponse.ReadOnly]
  def describeVirtualService(
      request: zio.aws.appmesh.model.DescribeVirtualServiceRequest
  ): IO[AwsError, zio.aws.appmesh.model.DescribeVirtualServiceResponse.ReadOnly]
  def deleteGatewayRoute(
      request: zio.aws.appmesh.model.DeleteGatewayRouteRequest
  ): IO[AwsError, zio.aws.appmesh.model.DeleteGatewayRouteResponse.ReadOnly]
  def untagResource(
      request: zio.aws.appmesh.model.UntagResourceRequest
  ): IO[AwsError, zio.aws.appmesh.model.UntagResourceResponse.ReadOnly]
  def deleteVirtualRouter(
      request: zio.aws.appmesh.model.DeleteVirtualRouterRequest
  ): IO[AwsError, zio.aws.appmesh.model.DeleteVirtualRouterResponse.ReadOnly]
  def describeMesh(
      request: zio.aws.appmesh.model.DescribeMeshRequest
  ): IO[AwsError, zio.aws.appmesh.model.DescribeMeshResponse.ReadOnly]
  def describeVirtualGateway(
      request: zio.aws.appmesh.model.DescribeVirtualGatewayRequest
  ): IO[AwsError, zio.aws.appmesh.model.DescribeVirtualGatewayResponse.ReadOnly]
  def updateVirtualRouter(
      request: zio.aws.appmesh.model.UpdateVirtualRouterRequest
  ): IO[AwsError, zio.aws.appmesh.model.UpdateVirtualRouterResponse.ReadOnly]
  def deleteMesh(
      request: zio.aws.appmesh.model.DeleteMeshRequest
  ): IO[AwsError, zio.aws.appmesh.model.DeleteMeshResponse.ReadOnly]
  def describeVirtualNode(
      request: zio.aws.appmesh.model.DescribeVirtualNodeRequest
  ): IO[AwsError, zio.aws.appmesh.model.DescribeVirtualNodeResponse.ReadOnly]
  def describeVirtualRouter(
      request: zio.aws.appmesh.model.DescribeVirtualRouterRequest
  ): IO[AwsError, zio.aws.appmesh.model.DescribeVirtualRouterResponse.ReadOnly]
  def listTagsForResource(
      request: zio.aws.appmesh.model.ListTagsForResourceRequest
  ): ZStream[Any, AwsError, zio.aws.appmesh.model.TagRef.ReadOnly]
  def listTagsForResourcePaginated(
      request: zio.aws.appmesh.model.ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.appmesh.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(
      request: zio.aws.appmesh.model.TagResourceRequest
  ): IO[AwsError, zio.aws.appmesh.model.TagResourceResponse.ReadOnly]
  def listVirtualNodes(
      request: zio.aws.appmesh.model.ListVirtualNodesRequest
  ): ZStream[Any, AwsError, zio.aws.appmesh.model.VirtualNodeRef.ReadOnly]
  def listVirtualNodesPaginated(
      request: zio.aws.appmesh.model.ListVirtualNodesRequest
  ): IO[AwsError, zio.aws.appmesh.model.ListVirtualNodesResponse.ReadOnly]
  def listMeshes(
      request: zio.aws.appmesh.model.ListMeshesRequest
  ): ZStream[Any, AwsError, zio.aws.appmesh.model.MeshRef.ReadOnly]
  def listMeshesPaginated(
      request: zio.aws.appmesh.model.ListMeshesRequest
  ): IO[AwsError, zio.aws.appmesh.model.ListMeshesResponse.ReadOnly]
  def updateVirtualService(
      request: zio.aws.appmesh.model.UpdateVirtualServiceRequest
  ): IO[AwsError, ReadOnly]
  def listVirtualServices(
      request: zio.aws.appmesh.model.ListVirtualServicesRequest
  ): ZStream[Any, AwsError, zio.aws.appmesh.model.VirtualServiceRef.ReadOnly]
  def listVirtualServicesPaginated(
      request: zio.aws.appmesh.model.ListVirtualServicesRequest
  ): IO[AwsError, zio.aws.appmesh.model.ListVirtualServicesResponse.ReadOnly]
  def deleteVirtualNode(
      request: zio.aws.appmesh.model.DeleteVirtualNodeRequest
  ): IO[AwsError, zio.aws.appmesh.model.DeleteVirtualNodeResponse.ReadOnly]
  def createGatewayRoute(
      request: zio.aws.appmesh.model.CreateGatewayRouteRequest
  ): IO[AwsError, zio.aws.appmesh.model.CreateGatewayRouteResponse.ReadOnly]
  def createMesh(
      request: zio.aws.appmesh.model.CreateMeshRequest
  ): IO[AwsError, zio.aws.appmesh.model.CreateMeshResponse.ReadOnly]
  def createVirtualGateway(
      request: zio.aws.appmesh.model.CreateVirtualGatewayRequest
  ): IO[AwsError, zio.aws.appmesh.model.CreateVirtualGatewayResponse.ReadOnly]
}
object AppMesh {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AppMesh] = customized(
    identity
  )
  def customized(
      customization: AppMeshAsyncClientBuilder => AppMeshAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AppMesh] = managed(
    customization
  ).toLayer
  def managed(
      customization: AppMeshAsyncClientBuilder => AppMeshAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, AppMesh] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = AppMeshAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[AppMeshAsyncClient, AppMeshAsyncClientBuilder](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[AppMeshAsyncClient, AppMeshAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  ) yield new AppMeshImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class AppMeshImpl[R](
      override val api: AppMeshAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AppMesh
      with AwsServiceBase[R] {
    override val serviceName: String = "AppMesh"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AppMeshImpl[R1] = new AppMeshImpl(api, newAspect, r)
    def describeRoute(
        request: zio.aws.appmesh.model.DescribeRouteRequest
    ): IO[AwsError, zio.aws.appmesh.model.DescribeRouteResponse.ReadOnly] =
      asyncRequestResponse[DescribeRouteRequest, DescribeRouteResponse](
        "describeRoute",
        api.describeRoute
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.DescribeRouteResponse.wrap)
        .provideEnvironment(r)
    def createVirtualNode(
        request: zio.aws.appmesh.model.CreateVirtualNodeRequest
    ): IO[AwsError, zio.aws.appmesh.model.CreateVirtualNodeResponse.ReadOnly] =
      asyncRequestResponse[CreateVirtualNodeRequest, CreateVirtualNodeResponse](
        "createVirtualNode",
        api.createVirtualNode
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.CreateVirtualNodeResponse.wrap)
        .provideEnvironment(r)
    def listGatewayRoutes(
        request: zio.aws.appmesh.model.ListGatewayRoutesRequest
    ): ZStream[Any, AwsError, zio.aws.appmesh.model.GatewayRouteRef.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListGatewayRoutesRequest,
        GatewayRouteRef,
        ListGatewayRoutesPublisher
      ]("listGatewayRoutes", api.listGatewayRoutesPaginator, _.gatewayRoutes())(
        request.buildAwsValue()
      ).map(item => zio.aws.appmesh.model.GatewayRouteRef.wrap(item))
        .provideEnvironment(r)
    def listGatewayRoutesPaginated(
        request: zio.aws.appmesh.model.ListGatewayRoutesRequest
    ): IO[AwsError, zio.aws.appmesh.model.ListGatewayRoutesResponse.ReadOnly] =
      asyncRequestResponse[ListGatewayRoutesRequest, ListGatewayRoutesResponse](
        "listGatewayRoutes",
        api.listGatewayRoutes
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.ListGatewayRoutesResponse.wrap)
        .provideEnvironment(r)
    def createRoute(
        request: zio.aws.appmesh.model.CreateRouteRequest
    ): IO[AwsError, zio.aws.appmesh.model.CreateRouteResponse.ReadOnly] =
      asyncRequestResponse[CreateRouteRequest, CreateRouteResponse](
        "createRoute",
        api.createRoute
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.CreateRouteResponse.wrap)
        .provideEnvironment(r)
    def deleteRoute(
        request: zio.aws.appmesh.model.DeleteRouteRequest
    ): IO[AwsError, zio.aws.appmesh.model.DeleteRouteResponse.ReadOnly] =
      asyncRequestResponse[DeleteRouteRequest, DeleteRouteResponse](
        "deleteRoute",
        api.deleteRoute
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.DeleteRouteResponse.wrap)
        .provideEnvironment(r)
    def updateGatewayRoute(
        request: zio.aws.appmesh.model.UpdateGatewayRouteRequest
    ): IO[AwsError, zio.aws.appmesh.model.UpdateGatewayRouteResponse.ReadOnly] =
      asyncRequestResponse[
        UpdateGatewayRouteRequest,
        UpdateGatewayRouteResponse
      ]("updateGatewayRoute", api.updateGatewayRoute)(request.buildAwsValue())
        .map(zio.aws.appmesh.model.UpdateGatewayRouteResponse.wrap)
        .provideEnvironment(r)
    def listVirtualGateways(
        request: zio.aws.appmesh.model.ListVirtualGatewaysRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualGatewayRef.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListVirtualGatewaysRequest,
      VirtualGatewayRef,
      ListVirtualGatewaysPublisher
    ](
      "listVirtualGateways",
      api.listVirtualGatewaysPaginator,
      _.virtualGateways()
    )(request.buildAwsValue())
      .map(item => zio.aws.appmesh.model.VirtualGatewayRef.wrap(item))
      .provideEnvironment(r)
    def listVirtualGatewaysPaginated(
        request: zio.aws.appmesh.model.ListVirtualGatewaysRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.ListVirtualGatewaysResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVirtualGatewaysRequest,
      ListVirtualGatewaysResponse
    ]("listVirtualGateways", api.listVirtualGateways)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.ListVirtualGatewaysResponse.wrap)
      .provideEnvironment(r)
    def updateRoute(
        request: zio.aws.appmesh.model.UpdateRouteRequest
    ): IO[AwsError, zio.aws.appmesh.model.UpdateRouteResponse.ReadOnly] =
      asyncRequestResponse[UpdateRouteRequest, UpdateRouteResponse](
        "updateRoute",
        api.updateRoute
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.UpdateRouteResponse.wrap)
        .provideEnvironment(r)
    def listVirtualRouters(
        request: zio.aws.appmesh.model.ListVirtualRoutersRequest
    ): ZStream[Any, AwsError, zio.aws.appmesh.model.VirtualRouterRef.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListVirtualRoutersRequest,
        VirtualRouterRef,
        ListVirtualRoutersPublisher
      ](
        "listVirtualRouters",
        api.listVirtualRoutersPaginator,
        _.virtualRouters()
      )(request.buildAwsValue())
        .map(item => zio.aws.appmesh.model.VirtualRouterRef.wrap(item))
        .provideEnvironment(r)
    def listVirtualRoutersPaginated(
        request: zio.aws.appmesh.model.ListVirtualRoutersRequest
    ): IO[AwsError, zio.aws.appmesh.model.ListVirtualRoutersResponse.ReadOnly] =
      asyncRequestResponse[
        ListVirtualRoutersRequest,
        ListVirtualRoutersResponse
      ]("listVirtualRouters", api.listVirtualRouters)(request.buildAwsValue())
        .map(zio.aws.appmesh.model.ListVirtualRoutersResponse.wrap)
        .provideEnvironment(r)
    def describeGatewayRoute(
        request: zio.aws.appmesh.model.DescribeGatewayRouteRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.DescribeGatewayRouteResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeGatewayRouteRequest,
      DescribeGatewayRouteResponse
    ]("describeGatewayRoute", api.describeGatewayRoute)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.DescribeGatewayRouteResponse.wrap)
      .provideEnvironment(r)
    def deleteVirtualGateway(
        request: zio.aws.appmesh.model.DeleteVirtualGatewayRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.DeleteVirtualGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVirtualGatewayRequest,
      DeleteVirtualGatewayResponse
    ]("deleteVirtualGateway", api.deleteVirtualGateway)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.DeleteVirtualGatewayResponse.wrap)
      .provideEnvironment(r)
    def updateVirtualGateway(
        request: zio.aws.appmesh.model.UpdateVirtualGatewayRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.UpdateVirtualGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateVirtualGatewayRequest,
      UpdateVirtualGatewayResponse
    ]("updateVirtualGateway", api.updateVirtualGateway)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.UpdateVirtualGatewayResponse.wrap)
      .provideEnvironment(r)
    def listRoutes(
        request: zio.aws.appmesh.model.ListRoutesRequest
    ): ZStream[Any, AwsError, zio.aws.appmesh.model.RouteRef.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListRoutesRequest,
        RouteRef,
        ListRoutesPublisher
      ]("listRoutes", api.listRoutesPaginator, _.routes())(
        request.buildAwsValue()
      ).map(item => zio.aws.appmesh.model.RouteRef.wrap(item))
        .provideEnvironment(r)
    def listRoutesPaginated(
        request: zio.aws.appmesh.model.ListRoutesRequest
    ): IO[AwsError, zio.aws.appmesh.model.ListRoutesResponse.ReadOnly] =
      asyncRequestResponse[ListRoutesRequest, ListRoutesResponse](
        "listRoutes",
        api.listRoutes
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.ListRoutesResponse.wrap)
        .provideEnvironment(r)
    def createVirtualRouter(
        request: zio.aws.appmesh.model.CreateVirtualRouterRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.CreateVirtualRouterResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVirtualRouterRequest,
      CreateVirtualRouterResponse
    ]("createVirtualRouter", api.createVirtualRouter)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.CreateVirtualRouterResponse.wrap)
      .provideEnvironment(r)
    def createVirtualService(
        request: zio.aws.appmesh.model.CreateVirtualServiceRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.CreateVirtualServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVirtualServiceRequest,
      CreateVirtualServiceResponse
    ]("createVirtualService", api.createVirtualService)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.CreateVirtualServiceResponse.wrap)
      .provideEnvironment(r)
    def updateVirtualNode(
        request: zio.aws.appmesh.model.UpdateVirtualNodeRequest
    ): IO[AwsError, zio.aws.appmesh.model.UpdateVirtualNodeResponse.ReadOnly] =
      asyncRequestResponse[UpdateVirtualNodeRequest, UpdateVirtualNodeResponse](
        "updateVirtualNode",
        api.updateVirtualNode
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.UpdateVirtualNodeResponse.wrap)
        .provideEnvironment(r)
    def updateMesh(
        request: zio.aws.appmesh.model.UpdateMeshRequest
    ): IO[AwsError, zio.aws.appmesh.model.UpdateMeshResponse.ReadOnly] =
      asyncRequestResponse[UpdateMeshRequest, UpdateMeshResponse](
        "updateMesh",
        api.updateMesh
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.UpdateMeshResponse.wrap)
        .provideEnvironment(r)
    def deleteVirtualService(
        request: zio.aws.appmesh.model.DeleteVirtualServiceRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.DeleteVirtualServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVirtualServiceRequest,
      DeleteVirtualServiceResponse
    ]("deleteVirtualService", api.deleteVirtualService)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.DeleteVirtualServiceResponse.wrap)
      .provideEnvironment(r)
    def describeVirtualService(
        request: zio.aws.appmesh.model.DescribeVirtualServiceRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.DescribeVirtualServiceResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVirtualServiceRequest,
      DescribeVirtualServiceResponse
    ]("describeVirtualService", api.describeVirtualService)(
      request.buildAwsValue()
    ).map(zio.aws.appmesh.model.DescribeVirtualServiceResponse.wrap)
      .provideEnvironment(r)
    def deleteGatewayRoute(
        request: zio.aws.appmesh.model.DeleteGatewayRouteRequest
    ): IO[AwsError, zio.aws.appmesh.model.DeleteGatewayRouteResponse.ReadOnly] =
      asyncRequestResponse[
        DeleteGatewayRouteRequest,
        DeleteGatewayRouteResponse
      ]("deleteGatewayRoute", api.deleteGatewayRoute)(request.buildAwsValue())
        .map(zio.aws.appmesh.model.DeleteGatewayRouteResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: zio.aws.appmesh.model.UntagResourceRequest
    ): IO[AwsError, zio.aws.appmesh.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[UntagResourceRequest, UntagResourceResponse](
        "untagResource",
        api.untagResource
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def deleteVirtualRouter(
        request: zio.aws.appmesh.model.DeleteVirtualRouterRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.DeleteVirtualRouterResponse.ReadOnly
    ] = asyncRequestResponse[
      DeleteVirtualRouterRequest,
      DeleteVirtualRouterResponse
    ]("deleteVirtualRouter", api.deleteVirtualRouter)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.DeleteVirtualRouterResponse.wrap)
      .provideEnvironment(r)
    def describeMesh(
        request: zio.aws.appmesh.model.DescribeMeshRequest
    ): IO[AwsError, zio.aws.appmesh.model.DescribeMeshResponse.ReadOnly] =
      asyncRequestResponse[DescribeMeshRequest, DescribeMeshResponse](
        "describeMesh",
        api.describeMesh
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.DescribeMeshResponse.wrap)
        .provideEnvironment(r)
    def describeVirtualGateway(
        request: zio.aws.appmesh.model.DescribeVirtualGatewayRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.DescribeVirtualGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVirtualGatewayRequest,
      DescribeVirtualGatewayResponse
    ]("describeVirtualGateway", api.describeVirtualGateway)(
      request.buildAwsValue()
    ).map(zio.aws.appmesh.model.DescribeVirtualGatewayResponse.wrap)
      .provideEnvironment(r)
    def updateVirtualRouter(
        request: zio.aws.appmesh.model.UpdateVirtualRouterRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.UpdateVirtualRouterResponse.ReadOnly
    ] = asyncRequestResponse[
      UpdateVirtualRouterRequest,
      UpdateVirtualRouterResponse
    ]("updateVirtualRouter", api.updateVirtualRouter)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.UpdateVirtualRouterResponse.wrap)
      .provideEnvironment(r)
    def deleteMesh(
        request: zio.aws.appmesh.model.DeleteMeshRequest
    ): IO[AwsError, zio.aws.appmesh.model.DeleteMeshResponse.ReadOnly] =
      asyncRequestResponse[DeleteMeshRequest, DeleteMeshResponse](
        "deleteMesh",
        api.deleteMesh
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.DeleteMeshResponse.wrap)
        .provideEnvironment(r)
    def describeVirtualNode(
        request: zio.aws.appmesh.model.DescribeVirtualNodeRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.DescribeVirtualNodeResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVirtualNodeRequest,
      DescribeVirtualNodeResponse
    ]("describeVirtualNode", api.describeVirtualNode)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.DescribeVirtualNodeResponse.wrap)
      .provideEnvironment(r)
    def describeVirtualRouter(
        request: zio.aws.appmesh.model.DescribeVirtualRouterRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.DescribeVirtualRouterResponse.ReadOnly
    ] = asyncRequestResponse[
      DescribeVirtualRouterRequest,
      DescribeVirtualRouterResponse
    ]("describeVirtualRouter", api.describeVirtualRouter)(
      request.buildAwsValue()
    ).map(zio.aws.appmesh.model.DescribeVirtualRouterResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: zio.aws.appmesh.model.ListTagsForResourceRequest
    ): ZStream[Any, AwsError, zio.aws.appmesh.model.TagRef.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListTagsForResourceRequest,
        TagRef,
        ListTagsForResourcePublisher
      ]("listTagsForResource", api.listTagsForResourcePaginator, _.tags())(
        request.buildAwsValue()
      ).map(item => zio.aws.appmesh.model.TagRef.wrap(item))
        .provideEnvironment(r)
    def listTagsForResourcePaginated(
        request: zio.aws.appmesh.model.ListTagsForResourceRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(
        request: zio.aws.appmesh.model.TagResourceRequest
    ): IO[AwsError, zio.aws.appmesh.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[TagResourceRequest, TagResourceResponse](
        "tagResource",
        api.tagResource
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def listVirtualNodes(
        request: zio.aws.appmesh.model.ListVirtualNodesRequest
    ): ZStream[Any, AwsError, zio.aws.appmesh.model.VirtualNodeRef.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListVirtualNodesRequest,
        VirtualNodeRef,
        ListVirtualNodesPublisher
      ]("listVirtualNodes", api.listVirtualNodesPaginator, _.virtualNodes())(
        request.buildAwsValue()
      ).map(item => zio.aws.appmesh.model.VirtualNodeRef.wrap(item))
        .provideEnvironment(r)
    def listVirtualNodesPaginated(
        request: zio.aws.appmesh.model.ListVirtualNodesRequest
    ): IO[AwsError, zio.aws.appmesh.model.ListVirtualNodesResponse.ReadOnly] =
      asyncRequestResponse[ListVirtualNodesRequest, ListVirtualNodesResponse](
        "listVirtualNodes",
        api.listVirtualNodes
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.ListVirtualNodesResponse.wrap)
        .provideEnvironment(r)
    def listMeshes(
        request: zio.aws.appmesh.model.ListMeshesRequest
    ): ZStream[Any, AwsError, zio.aws.appmesh.model.MeshRef.ReadOnly] =
      asyncJavaPaginatedRequest[
        ListMeshesRequest,
        MeshRef,
        ListMeshesPublisher
      ]("listMeshes", api.listMeshesPaginator, _.meshes())(
        request.buildAwsValue()
      ).map(item => zio.aws.appmesh.model.MeshRef.wrap(item))
        .provideEnvironment(r)
    def listMeshesPaginated(
        request: zio.aws.appmesh.model.ListMeshesRequest
    ): IO[AwsError, zio.aws.appmesh.model.ListMeshesResponse.ReadOnly] =
      asyncRequestResponse[ListMeshesRequest, ListMeshesResponse](
        "listMeshes",
        api.listMeshes
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.ListMeshesResponse.wrap)
        .provideEnvironment(r)
    def updateVirtualService(
        request: zio.aws.appmesh.model.UpdateVirtualServiceRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      UpdateVirtualServiceRequest,
      UpdateVirtualServiceResponse
    ]("updateVirtualService", api.updateVirtualService)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.UpdateVirtualServiceResponse.wrap)
      .provideEnvironment(r)
    def listVirtualServices(
        request: zio.aws.appmesh.model.ListVirtualServicesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.appmesh.model.VirtualServiceRef.ReadOnly
    ] = asyncJavaPaginatedRequest[
      ListVirtualServicesRequest,
      VirtualServiceRef,
      ListVirtualServicesPublisher
    ](
      "listVirtualServices",
      api.listVirtualServicesPaginator,
      _.virtualServices()
    )(request.buildAwsValue())
      .map(item => zio.aws.appmesh.model.VirtualServiceRef.wrap(item))
      .provideEnvironment(r)
    def listVirtualServicesPaginated(
        request: zio.aws.appmesh.model.ListVirtualServicesRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.ListVirtualServicesResponse.ReadOnly
    ] = asyncRequestResponse[
      ListVirtualServicesRequest,
      ListVirtualServicesResponse
    ]("listVirtualServices", api.listVirtualServices)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.ListVirtualServicesResponse.wrap)
      .provideEnvironment(r)
    def deleteVirtualNode(
        request: zio.aws.appmesh.model.DeleteVirtualNodeRequest
    ): IO[AwsError, zio.aws.appmesh.model.DeleteVirtualNodeResponse.ReadOnly] =
      asyncRequestResponse[DeleteVirtualNodeRequest, DeleteVirtualNodeResponse](
        "deleteVirtualNode",
        api.deleteVirtualNode
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.DeleteVirtualNodeResponse.wrap)
        .provideEnvironment(r)
    def createGatewayRoute(
        request: zio.aws.appmesh.model.CreateGatewayRouteRequest
    ): IO[AwsError, zio.aws.appmesh.model.CreateGatewayRouteResponse.ReadOnly] =
      asyncRequestResponse[
        CreateGatewayRouteRequest,
        CreateGatewayRouteResponse
      ]("createGatewayRoute", api.createGatewayRoute)(request.buildAwsValue())
        .map(zio.aws.appmesh.model.CreateGatewayRouteResponse.wrap)
        .provideEnvironment(r)
    def createMesh(
        request: zio.aws.appmesh.model.CreateMeshRequest
    ): IO[AwsError, zio.aws.appmesh.model.CreateMeshResponse.ReadOnly] =
      asyncRequestResponse[CreateMeshRequest, CreateMeshResponse](
        "createMesh",
        api.createMesh
      )(request.buildAwsValue())
        .map(zio.aws.appmesh.model.CreateMeshResponse.wrap)
        .provideEnvironment(r)
    def createVirtualGateway(
        request: zio.aws.appmesh.model.CreateVirtualGatewayRequest
    ): IO[
      AwsError,
      zio.aws.appmesh.model.CreateVirtualGatewayResponse.ReadOnly
    ] = asyncRequestResponse[
      CreateVirtualGatewayRequest,
      CreateVirtualGatewayResponse
    ]("createVirtualGateway", api.createVirtualGateway)(request.buildAwsValue())
      .map(zio.aws.appmesh.model.CreateVirtualGatewayResponse.wrap)
      .provideEnvironment(r)
  }
  def describeRoute(request: zio.aws.appmesh.model.DescribeRouteRequest): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DescribeRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeRoute(request))
  def createVirtualNode(
      request: zio.aws.appmesh.model.CreateVirtualNodeRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.CreateVirtualNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVirtualNode(request))
  def listGatewayRoutes(
      request: zio.aws.appmesh.model.ListGatewayRoutesRequest
  ): ZStream[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.GatewayRouteRef.ReadOnly
  ] = ZStream.serviceWithStream(_.listGatewayRoutes(request))
  def listGatewayRoutesPaginated(
      request: zio.aws.appmesh.model.ListGatewayRoutesRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.ListGatewayRoutesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listGatewayRoutesPaginated(request))
  def createRoute(request: zio.aws.appmesh.model.CreateRouteRequest): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.CreateRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createRoute(request))
  def deleteRoute(request: zio.aws.appmesh.model.DeleteRouteRequest): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DeleteRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteRoute(request))
  def updateGatewayRoute(
      request: zio.aws.appmesh.model.UpdateGatewayRouteRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.UpdateGatewayRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateGatewayRoute(request))
  def listVirtualGateways(
      request: zio.aws.appmesh.model.ListVirtualGatewaysRequest
  ): ZStream[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.VirtualGatewayRef.ReadOnly
  ] = ZStream.serviceWithStream(_.listVirtualGateways(request))
  def listVirtualGatewaysPaginated(
      request: zio.aws.appmesh.model.ListVirtualGatewaysRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.ListVirtualGatewaysResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVirtualGatewaysPaginated(request))
  def updateRoute(request: zio.aws.appmesh.model.UpdateRouteRequest): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.UpdateRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateRoute(request))
  def listVirtualRouters(
      request: zio.aws.appmesh.model.ListVirtualRoutersRequest
  ): ZStream[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.VirtualRouterRef.ReadOnly
  ] = ZStream.serviceWithStream(_.listVirtualRouters(request))
  def listVirtualRoutersPaginated(
      request: zio.aws.appmesh.model.ListVirtualRoutersRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.ListVirtualRoutersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVirtualRoutersPaginated(request))
  def describeGatewayRoute(
      request: zio.aws.appmesh.model.DescribeGatewayRouteRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DescribeGatewayRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGatewayRoute(request))
  def deleteVirtualGateway(
      request: zio.aws.appmesh.model.DeleteVirtualGatewayRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DeleteVirtualGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVirtualGateway(request))
  def updateVirtualGateway(
      request: zio.aws.appmesh.model.UpdateVirtualGatewayRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.UpdateVirtualGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVirtualGateway(request))
  def listRoutes(request: zio.aws.appmesh.model.ListRoutesRequest): ZStream[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.RouteRef.ReadOnly
  ] = ZStream.serviceWithStream(_.listRoutes(request))
  def listRoutesPaginated(
      request: zio.aws.appmesh.model.ListRoutesRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.ListRoutesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listRoutesPaginated(request))
  def createVirtualRouter(
      request: zio.aws.appmesh.model.CreateVirtualRouterRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.CreateVirtualRouterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVirtualRouter(request))
  def createVirtualService(
      request: zio.aws.appmesh.model.CreateVirtualServiceRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.CreateVirtualServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVirtualService(request))
  def updateVirtualNode(
      request: zio.aws.appmesh.model.UpdateVirtualNodeRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.UpdateVirtualNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVirtualNode(request))
  def updateMesh(request: zio.aws.appmesh.model.UpdateMeshRequest): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.UpdateMeshResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateMesh(request))
  def deleteVirtualService(
      request: zio.aws.appmesh.model.DeleteVirtualServiceRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DeleteVirtualServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVirtualService(request))
  def describeVirtualService(
      request: zio.aws.appmesh.model.DescribeVirtualServiceRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DescribeVirtualServiceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVirtualService(request))
  def deleteGatewayRoute(
      request: zio.aws.appmesh.model.DeleteGatewayRouteRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DeleteGatewayRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGatewayRoute(request))
  def untagResource(request: zio.aws.appmesh.model.UntagResourceRequest): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def deleteVirtualRouter(
      request: zio.aws.appmesh.model.DeleteVirtualRouterRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DeleteVirtualRouterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVirtualRouter(request))
  def describeMesh(request: zio.aws.appmesh.model.DescribeMeshRequest): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DescribeMeshResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeMesh(request))
  def describeVirtualGateway(
      request: zio.aws.appmesh.model.DescribeVirtualGatewayRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DescribeVirtualGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVirtualGateway(request))
  def updateVirtualRouter(
      request: zio.aws.appmesh.model.UpdateVirtualRouterRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.UpdateVirtualRouterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateVirtualRouter(request))
  def deleteMesh(request: zio.aws.appmesh.model.DeleteMeshRequest): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DeleteMeshResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteMesh(request))
  def describeVirtualNode(
      request: zio.aws.appmesh.model.DescribeVirtualNodeRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DescribeVirtualNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVirtualNode(request))
  def describeVirtualRouter(
      request: zio.aws.appmesh.model.DescribeVirtualRouterRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DescribeVirtualRouterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeVirtualRouter(request))
  def listTagsForResource(
      request: zio.aws.appmesh.model.ListTagsForResourceRequest
  ): ZStream[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.TagRef.ReadOnly
  ] = ZStream.serviceWithStream(_.listTagsForResource(request))
  def listTagsForResourcePaginated(
      request: zio.aws.appmesh.model.ListTagsForResourceRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResourcePaginated(request))
  def tagResource(request: zio.aws.appmesh.model.TagResourceRequest): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def listVirtualNodes(
      request: zio.aws.appmesh.model.ListVirtualNodesRequest
  ): ZStream[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.VirtualNodeRef.ReadOnly
  ] = ZStream.serviceWithStream(_.listVirtualNodes(request))
  def listVirtualNodesPaginated(
      request: zio.aws.appmesh.model.ListVirtualNodesRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.ListVirtualNodesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVirtualNodesPaginated(request))
  def listMeshes(request: zio.aws.appmesh.model.ListMeshesRequest): ZStream[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.MeshRef.ReadOnly
  ] = ZStream.serviceWithStream(_.listMeshes(request))
  def listMeshesPaginated(
      request: zio.aws.appmesh.model.ListMeshesRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.ListMeshesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listMeshesPaginated(request))
  def updateVirtualService(
      request: zio.aws.appmesh.model.UpdateVirtualServiceRequest
  ): ZIO[zio.aws.appmesh.AppMesh, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.updateVirtualService(request))
  def listVirtualServices(
      request: zio.aws.appmesh.model.ListVirtualServicesRequest
  ): ZStream[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.VirtualServiceRef.ReadOnly
  ] = ZStream.serviceWithStream(_.listVirtualServices(request))
  def listVirtualServicesPaginated(
      request: zio.aws.appmesh.model.ListVirtualServicesRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.ListVirtualServicesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listVirtualServicesPaginated(request))
  def deleteVirtualNode(
      request: zio.aws.appmesh.model.DeleteVirtualNodeRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.DeleteVirtualNodeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteVirtualNode(request))
  def createGatewayRoute(
      request: zio.aws.appmesh.model.CreateGatewayRouteRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.CreateGatewayRouteResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGatewayRoute(request))
  def createMesh(request: zio.aws.appmesh.model.CreateMeshRequest): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.CreateMeshResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createMesh(request))
  def createVirtualGateway(
      request: zio.aws.appmesh.model.CreateVirtualGatewayRequest
  ): ZIO[
    zio.aws.appmesh.AppMesh,
    AwsError,
    zio.aws.appmesh.model.CreateVirtualGatewayResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createVirtualGateway(request))
}
