package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class VirtualNodeSpec(
    backendDefaults: Option[zio.aws.appmesh.model.BackendDefaults] = None,
    backends: Option[Iterable[zio.aws.appmesh.model.Backend]] = None,
    listeners: Option[Iterable[zio.aws.appmesh.model.Listener]] = None,
    logging: Option[zio.aws.appmesh.model.Logging] = None,
    serviceDiscovery: Option[zio.aws.appmesh.model.ServiceDiscovery] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.VirtualNodeSpec = {
    import VirtualNodeSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.VirtualNodeSpec
      .builder()
      .optionallyWith(backendDefaults.map(value => value.buildAwsValue()))(
        _.backendDefaults
      )
      .optionallyWith(
        backends.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backends)
      .optionallyWith(
        listeners.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listeners)
      .optionallyWith(logging.map(value => value.buildAwsValue()))(_.logging)
      .optionallyWith(serviceDiscovery.map(value => value.buildAwsValue()))(
        _.serviceDiscovery
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly =
    zio.aws.appmesh.model.VirtualNodeSpec.wrap(buildAwsValue())
}
object VirtualNodeSpec {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.VirtualNodeSpec
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.VirtualNodeSpec =
      zio.aws.appmesh.model.VirtualNodeSpec(
        backendDefaults.map(value => value.asEditable),
        backends.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        listeners.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        logging.map(value => value.asEditable),
        serviceDiscovery.map(value => value.asEditable)
      )
    def backendDefaults: Option[zio.aws.appmesh.model.BackendDefaults.ReadOnly]
    def backends: Option[List[zio.aws.appmesh.model.Backend.ReadOnly]]
    def listeners: Option[List[zio.aws.appmesh.model.Listener.ReadOnly]]
    def logging: Option[zio.aws.appmesh.model.Logging.ReadOnly]
    def serviceDiscovery
        : Option[zio.aws.appmesh.model.ServiceDiscovery.ReadOnly]
    def getBackendDefaults
        : ZIO[Any, AwsError, zio.aws.appmesh.model.BackendDefaults.ReadOnly] =
      AwsError.unwrapOptionField("backendDefaults", backendDefaults)
    def getBackends
        : ZIO[Any, AwsError, List[zio.aws.appmesh.model.Backend.ReadOnly]] =
      AwsError.unwrapOptionField("backends", backends)
    def getListeners
        : ZIO[Any, AwsError, List[zio.aws.appmesh.model.Listener.ReadOnly]] =
      AwsError.unwrapOptionField("listeners", listeners)
    def getLogging: ZIO[Any, AwsError, zio.aws.appmesh.model.Logging.ReadOnly] =
      AwsError.unwrapOptionField("logging", logging)
    def getServiceDiscovery
        : ZIO[Any, AwsError, zio.aws.appmesh.model.ServiceDiscovery.ReadOnly] =
      AwsError.unwrapOptionField("serviceDiscovery", serviceDiscovery)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeSpec
  ) extends zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly {
    override val backendDefaults
        : Option[zio.aws.appmesh.model.BackendDefaults.ReadOnly] = scala
      .Option(impl.backendDefaults())
      .map(value => zio.aws.appmesh.model.BackendDefaults.wrap(value))
    override val backends
        : Option[List[zio.aws.appmesh.model.Backend.ReadOnly]] = scala
      .Option(impl.backends())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appmesh.model.Backend.wrap(item)
        }.toList
      )
    override val listeners
        : Option[List[zio.aws.appmesh.model.Listener.ReadOnly]] = scala
      .Option(impl.listeners())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.appmesh.model.Listener.wrap(item)
        }.toList
      )
    override val logging: Option[zio.aws.appmesh.model.Logging.ReadOnly] = scala
      .Option(impl.logging())
      .map(value => zio.aws.appmesh.model.Logging.wrap(value))
    override val serviceDiscovery
        : Option[zio.aws.appmesh.model.ServiceDiscovery.ReadOnly] = scala
      .Option(impl.serviceDiscovery())
      .map(value => zio.aws.appmesh.model.ServiceDiscovery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.VirtualNodeSpec
  ): zio.aws.appmesh.model.VirtualNodeSpec.ReadOnly = new Wrapper(impl)
}
