package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BackendDefaults(
    clientPolicy: Option[zio.aws.appmesh.model.ClientPolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.BackendDefaults = {
    import BackendDefaults.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.BackendDefaults
      .builder()
      .optionallyWith(clientPolicy.map(value => value.buildAwsValue()))(
        _.clientPolicy
      )
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.BackendDefaults.ReadOnly =
    zio.aws.appmesh.model.BackendDefaults.wrap(buildAwsValue())
}
object BackendDefaults {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.BackendDefaults
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.BackendDefaults =
      zio.aws.appmesh.model
        .BackendDefaults(clientPolicy.map(value => value.asEditable))
    def clientPolicy: Option[zio.aws.appmesh.model.ClientPolicy.ReadOnly]
    def getClientPolicy
        : ZIO[Any, AwsError, zio.aws.appmesh.model.ClientPolicy.ReadOnly] =
      AwsError.unwrapOptionField("clientPolicy", clientPolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.BackendDefaults
  ) extends zio.aws.appmesh.model.BackendDefaults.ReadOnly {
    override val clientPolicy
        : Option[zio.aws.appmesh.model.ClientPolicy.ReadOnly] = scala
      .Option(impl.clientPolicy())
      .map(value => zio.aws.appmesh.model.ClientPolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.BackendDefaults
  ): zio.aws.appmesh.model.BackendDefaults.ReadOnly = new Wrapper(impl)
}
