package zio.aws.appmesh.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ServiceDiscovery(
    awsCloudMap: Option[zio.aws.appmesh.model.AwsCloudMapServiceDiscovery] =
      None,
    dns: Option[zio.aws.appmesh.model.DnsServiceDiscovery] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.ServiceDiscovery = {
    import ServiceDiscovery.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.ServiceDiscovery
      .builder()
      .optionallyWith(awsCloudMap.map(value => value.buildAwsValue()))(
        _.awsCloudMap
      )
      .optionallyWith(dns.map(value => value.buildAwsValue()))(_.dns)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.ServiceDiscovery.ReadOnly =
    zio.aws.appmesh.model.ServiceDiscovery.wrap(buildAwsValue())
}
object ServiceDiscovery {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.appmesh.model.ServiceDiscovery
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.ServiceDiscovery =
      zio.aws.appmesh.model.ServiceDiscovery(
        awsCloudMap.map(value => value.asEditable),
        dns.map(value => value.asEditable)
      )
    def awsCloudMap
        : Option[zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.ReadOnly]
    def dns: Option[zio.aws.appmesh.model.DnsServiceDiscovery.ReadOnly]
    def getAwsCloudMap: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.ReadOnly
    ] = AwsError.unwrapOptionField("awsCloudMap", awsCloudMap)
    def getDns: ZIO[
      Any,
      AwsError,
      zio.aws.appmesh.model.DnsServiceDiscovery.ReadOnly
    ] = AwsError.unwrapOptionField("dns", dns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.ServiceDiscovery
  ) extends zio.aws.appmesh.model.ServiceDiscovery.ReadOnly {
    override val awsCloudMap
        : Option[zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.ReadOnly] =
      scala
        .Option(impl.awsCloudMap())
        .map(value =>
          zio.aws.appmesh.model.AwsCloudMapServiceDiscovery.wrap(value)
        )
    override val dns
        : Option[zio.aws.appmesh.model.DnsServiceDiscovery.ReadOnly] = scala
      .Option(impl.dns())
      .map(value => zio.aws.appmesh.model.DnsServiceDiscovery.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.ServiceDiscovery
  ): zio.aws.appmesh.model.ServiceDiscovery.ReadOnly = new Wrapper(impl)
}
