package zio.aws.appmesh.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.appmesh.model.primitives.RoutePriority
import scala.jdk.CollectionConverters._
final case class RouteSpec(
    grpcRoute: Option[zio.aws.appmesh.model.GrpcRoute] = None,
    http2Route: Option[zio.aws.appmesh.model.HttpRoute] = None,
    httpRoute: Option[zio.aws.appmesh.model.HttpRoute] = None,
    priority: Option[RoutePriority] = None,
    tcpRoute: Option[zio.aws.appmesh.model.TcpRoute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.appmesh.model.RouteSpec = {
    import RouteSpec.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.appmesh.model.RouteSpec
      .builder()
      .optionallyWith(grpcRoute.map(value => value.buildAwsValue()))(
        _.grpcRoute
      )
      .optionallyWith(http2Route.map(value => value.buildAwsValue()))(
        _.http2Route
      )
      .optionallyWith(httpRoute.map(value => value.buildAwsValue()))(
        _.httpRoute
      )
      .optionallyWith(
        priority.map(value => RoutePriority.unwrap(value): Integer)
      )(_.priority)
      .optionallyWith(tcpRoute.map(value => value.buildAwsValue()))(_.tcpRoute)
      .build()
  }
  def asReadOnly: zio.aws.appmesh.model.RouteSpec.ReadOnly =
    zio.aws.appmesh.model.RouteSpec.wrap(buildAwsValue())
}
object RouteSpec {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.appmesh.model.RouteSpec] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.appmesh.model.RouteSpec =
      zio.aws.appmesh.model.RouteSpec(
        grpcRoute.map(value => value.asEditable),
        http2Route.map(value => value.asEditable),
        httpRoute.map(value => value.asEditable),
        priority.map(value => value),
        tcpRoute.map(value => value.asEditable)
      )
    def grpcRoute: Option[zio.aws.appmesh.model.GrpcRoute.ReadOnly]
    def http2Route: Option[zio.aws.appmesh.model.HttpRoute.ReadOnly]
    def httpRoute: Option[zio.aws.appmesh.model.HttpRoute.ReadOnly]
    def priority: Option[RoutePriority]
    def tcpRoute: Option[zio.aws.appmesh.model.TcpRoute.ReadOnly]
    def getGrpcRoute
        : ZIO[Any, AwsError, zio.aws.appmesh.model.GrpcRoute.ReadOnly] =
      AwsError.unwrapOptionField("grpcRoute", grpcRoute)
    def getHttp2Route
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpRoute.ReadOnly] =
      AwsError.unwrapOptionField("http2Route", http2Route)
    def getHttpRoute
        : ZIO[Any, AwsError, zio.aws.appmesh.model.HttpRoute.ReadOnly] =
      AwsError.unwrapOptionField("httpRoute", httpRoute)
    def getPriority: ZIO[Any, AwsError, RoutePriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getTcpRoute
        : ZIO[Any, AwsError, zio.aws.appmesh.model.TcpRoute.ReadOnly] =
      AwsError.unwrapOptionField("tcpRoute", tcpRoute)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.appmesh.model.RouteSpec
  ) extends zio.aws.appmesh.model.RouteSpec.ReadOnly {
    override val grpcRoute: Option[zio.aws.appmesh.model.GrpcRoute.ReadOnly] =
      scala
        .Option(impl.grpcRoute())
        .map(value => zio.aws.appmesh.model.GrpcRoute.wrap(value))
    override val http2Route: Option[zio.aws.appmesh.model.HttpRoute.ReadOnly] =
      scala
        .Option(impl.http2Route())
        .map(value => zio.aws.appmesh.model.HttpRoute.wrap(value))
    override val httpRoute: Option[zio.aws.appmesh.model.HttpRoute.ReadOnly] =
      scala
        .Option(impl.httpRoute())
        .map(value => zio.aws.appmesh.model.HttpRoute.wrap(value))
    override val priority: Option[RoutePriority] = scala
      .Option(impl.priority())
      .map(value => zio.aws.appmesh.model.primitives.RoutePriority(value))
    override val tcpRoute: Option[zio.aws.appmesh.model.TcpRoute.ReadOnly] =
      scala
        .Option(impl.tcpRoute())
        .map(value => zio.aws.appmesh.model.TcpRoute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.appmesh.model.RouteSpec
  ): zio.aws.appmesh.model.RouteSpec.ReadOnly = new Wrapper(impl)
}
