package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  Remarks,
  WorkloadName,
  ComponentName,
  WorkloadId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Workload(
    workloadId: Optional[WorkloadId] = Optional.Absent,
    componentName: Optional[ComponentName] = Optional.Absent,
    workloadName: Optional[WorkloadName] = Optional.Absent,
    tier: Optional[zio.aws.applicationinsights.model.Tier] = Optional.Absent,
    workloadRemarks: Optional[Remarks] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.Workload = {
    import Workload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.Workload
      .builder()
      .optionallyWith(
        workloadId.map(value => WorkloadId.unwrap(value): java.lang.String)
      )(_.workloadId)
      .optionallyWith(
        componentName.map(value =>
          ComponentName.unwrap(value): java.lang.String
        )
      )(_.componentName)
      .optionallyWith(
        workloadName.map(value => WorkloadName.unwrap(value): java.lang.String)
      )(_.workloadName)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        workloadRemarks.map(value => Remarks.unwrap(value): java.lang.String)
      )(_.workloadRemarks)
      .build()
  }
  def asReadOnly: zio.aws.applicationinsights.model.Workload.ReadOnly =
    zio.aws.applicationinsights.model.Workload.wrap(buildAwsValue())
}
object Workload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.Workload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.Workload =
      zio.aws.applicationinsights.model.Workload(
        workloadId.map(value => value),
        componentName.map(value => value),
        workloadName.map(value => value),
        tier.map(value => value),
        workloadRemarks.map(value => value)
      )
    def workloadId: Optional[WorkloadId]
    def componentName: Optional[ComponentName]
    def workloadName: Optional[WorkloadName]
    def tier: Optional[zio.aws.applicationinsights.model.Tier]
    def workloadRemarks: Optional[Remarks]
    def getWorkloadId: ZIO[Any, AwsError, WorkloadId] =
      AwsError.unwrapOptionField("workloadId", workloadId)
    def getComponentName: ZIO[Any, AwsError, ComponentName] =
      AwsError.unwrapOptionField("componentName", componentName)
    def getWorkloadName: ZIO[Any, AwsError, WorkloadName] =
      AwsError.unwrapOptionField("workloadName", workloadName)
    def getTier: ZIO[Any, AwsError, zio.aws.applicationinsights.model.Tier] =
      AwsError.unwrapOptionField("tier", tier)
    def getWorkloadRemarks: ZIO[Any, AwsError, Remarks] =
      AwsError.unwrapOptionField("workloadRemarks", workloadRemarks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.Workload
  ) extends zio.aws.applicationinsights.model.Workload.ReadOnly {
    override val workloadId: Optional[WorkloadId] = zio.aws.core.internal
      .optionalFromNullable(impl.workloadId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.WorkloadId(value)
      )
    override val componentName: Optional[ComponentName] = zio.aws.core.internal
      .optionalFromNullable(impl.componentName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.ComponentName(value)
      )
    override val workloadName: Optional[WorkloadName] = zio.aws.core.internal
      .optionalFromNullable(impl.workloadName())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.WorkloadName(value)
      )
    override val tier: Optional[zio.aws.applicationinsights.model.Tier] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tier())
        .map(value => zio.aws.applicationinsights.model.Tier.wrap(value))
    override val workloadRemarks: Optional[Remarks] = zio.aws.core.internal
      .optionalFromNullable(impl.workloadRemarks())
      .map(value => zio.aws.applicationinsights.model.primitives.Remarks(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.Workload
  ): zio.aws.applicationinsights.model.Workload.ReadOnly = new Wrapper(impl)
}
