package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{AccountId, ProblemId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeProblemRequest(
    problemId: ProblemId,
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest = {
    import DescribeProblemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest
      .builder()
      .problemId(ProblemId.unwrap(problemId): java.lang.String)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeProblemRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeProblemRequest
      .wrap(buildAwsValue())
}
object DescribeProblemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.DescribeProblemRequest =
      zio.aws.applicationinsights.model
        .DescribeProblemRequest(problemId, accountId.map(value => value))
    def problemId: ProblemId
    def accountId: Optional[AccountId]
    def getProblemId: ZIO[Any, Nothing, ProblemId] = ZIO.succeed(problemId)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest
  ) extends zio.aws.applicationinsights.model.DescribeProblemRequest.ReadOnly {
    override val problemId: ProblemId =
      zio.aws.applicationinsights.model.primitives.ProblemId(impl.problemId())
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeProblemRequest
  ): zio.aws.applicationinsights.model.DescribeProblemRequest.ReadOnly =
    new Wrapper(impl)
}
