package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.WorkloadId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AddWorkloadResponse(
    workloadId: Optional[WorkloadId] = Optional.Absent,
    workloadConfiguration: Optional[
      zio.aws.applicationinsights.model.WorkloadConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.AddWorkloadResponse = {
    import AddWorkloadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.AddWorkloadResponse
      .builder()
      .optionallyWith(
        workloadId.map(value => WorkloadId.unwrap(value): java.lang.String)
      )(_.workloadId)
      .optionallyWith(
        workloadConfiguration.map(value => value.buildAwsValue())
      )(_.workloadConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.AddWorkloadResponse.ReadOnly =
    zio.aws.applicationinsights.model.AddWorkloadResponse.wrap(buildAwsValue())
}
object AddWorkloadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.AddWorkloadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.AddWorkloadResponse =
      zio.aws.applicationinsights.model.AddWorkloadResponse(
        workloadId.map(value => value),
        workloadConfiguration.map(value => value.asEditable)
      )
    def workloadId: Optional[WorkloadId]
    def workloadConfiguration: Optional[
      zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly
    ]
    def getWorkloadId: ZIO[Any, AwsError, WorkloadId] =
      AwsError.unwrapOptionField("workloadId", workloadId)
    def getWorkloadConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("workloadConfiguration", workloadConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.AddWorkloadResponse
  ) extends zio.aws.applicationinsights.model.AddWorkloadResponse.ReadOnly {
    override val workloadId: Optional[WorkloadId] = zio.aws.core.internal
      .optionalFromNullable(impl.workloadId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.WorkloadId(value)
      )
    override val workloadConfiguration: Optional[
      zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workloadConfiguration())
      .map(value =>
        zio.aws.applicationinsights.model.WorkloadConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.AddWorkloadResponse
  ): zio.aws.applicationinsights.model.AddWorkloadResponse.ReadOnly =
    new Wrapper(impl)
}
