package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.ProblemId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UpdateProblemRequest(
    problemId: ProblemId,
    updateStatus: Optional[zio.aws.applicationinsights.model.UpdateStatus] =
      Optional.Absent,
    visibility: Optional[zio.aws.applicationinsights.model.Visibility] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.UpdateProblemRequest = {
    import UpdateProblemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.UpdateProblemRequest
      .builder()
      .problemId(ProblemId.unwrap(problemId): java.lang.String)
      .optionallyWith(updateStatus.map(value => value.unwrap))(_.updateStatus)
      .optionallyWith(visibility.map(value => value.unwrap))(_.visibility)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.UpdateProblemRequest.ReadOnly =
    zio.aws.applicationinsights.model.UpdateProblemRequest.wrap(buildAwsValue())
}
object UpdateProblemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.UpdateProblemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.UpdateProblemRequest =
      zio.aws.applicationinsights.model.UpdateProblemRequest(
        problemId,
        updateStatus.map(value => value),
        visibility.map(value => value)
      )
    def problemId: ProblemId
    def updateStatus: Optional[zio.aws.applicationinsights.model.UpdateStatus]
    def visibility: Optional[zio.aws.applicationinsights.model.Visibility]
    def getProblemId: ZIO[Any, Nothing, ProblemId] = ZIO.succeed(problemId)
    def getUpdateStatus
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.UpdateStatus] =
      AwsError.unwrapOptionField("updateStatus", updateStatus)
    def getVisibility
        : ZIO[Any, AwsError, zio.aws.applicationinsights.model.Visibility] =
      AwsError.unwrapOptionField("visibility", visibility)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateProblemRequest
  ) extends zio.aws.applicationinsights.model.UpdateProblemRequest.ReadOnly {
    override val problemId: ProblemId =
      zio.aws.applicationinsights.model.primitives.ProblemId(impl.problemId())
    override val updateStatus
        : Optional[zio.aws.applicationinsights.model.UpdateStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updateStatus())
        .map(value =>
          zio.aws.applicationinsights.model.UpdateStatus.wrap(value)
        )
    override val visibility
        : Optional[zio.aws.applicationinsights.model.Visibility] =
      zio.aws.core.internal
        .optionalFromNullable(impl.visibility())
        .map(value => zio.aws.applicationinsights.model.Visibility.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.UpdateProblemRequest
  ): zio.aws.applicationinsights.model.UpdateProblemRequest.ReadOnly =
    new Wrapper(impl)
}
