package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  AccountId,
  ComponentName,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeComponentRequest(
    resourceGroupName: ResourceGroupName,
    componentName: ComponentName,
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest = {
    import DescribeComponentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeComponentRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeComponentRequest
      .wrap(buildAwsValue())
}
object DescribeComponentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.DescribeComponentRequest =
      zio.aws.applicationinsights.model.DescribeComponentRequest(
        resourceGroupName,
        componentName,
        accountId.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def componentName: ComponentName
    def accountId: Optional[AccountId]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest
  ) extends zio.aws.applicationinsights.model.DescribeComponentRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: ComponentName =
      zio.aws.applicationinsights.model.primitives
        .ComponentName(impl.componentName())
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeComponentRequest
  ): zio.aws.applicationinsights.model.DescribeComponentRequest.ReadOnly =
    new Wrapper(impl)
}
