package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait UpdateStatus {
  def unwrap
      : software.amazon.awssdk.services.applicationinsights.model.UpdateStatus
}
object UpdateStatus {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.UpdateStatus
  ): zio.aws.applicationinsights.model.UpdateStatus = value match {
    case software.amazon.awssdk.services.applicationinsights.model.UpdateStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.UpdateStatus.RESOLVED =>
      val r = RESOLVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.UpdateStatus =
      software.amazon.awssdk.services.applicationinsights.model.UpdateStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RESOLVED extends zio.aws.applicationinsights.model.UpdateStatus {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.UpdateStatus =
      software.amazon.awssdk.services.applicationinsights.model.UpdateStatus.RESOLVED
  }
}
