package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait Status {
  def unwrap: software.amazon.awssdk.services.applicationinsights.model.Status
}
object Status {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.Status
  ): zio.aws.applicationinsights.model.Status = value match {
    case software.amazon.awssdk.services.applicationinsights.model.Status.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.Status.IGNORE =>
      val r = IGNORE
      r
    case software.amazon.awssdk.services.applicationinsights.model.Status.RESOLVED =>
      val r = RESOLVED
      r
    case software.amazon.awssdk.services.applicationinsights.model.Status.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.applicationinsights.model.Status.RECURRING =>
      val r = RECURRING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Status =
      software.amazon.awssdk.services.applicationinsights.model.Status.UNKNOWN_TO_SDK_VERSION
  }
  case object IGNORE extends zio.aws.applicationinsights.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Status =
      software.amazon.awssdk.services.applicationinsights.model.Status.IGNORE
  }
  case object RESOLVED extends zio.aws.applicationinsights.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Status =
      software.amazon.awssdk.services.applicationinsights.model.Status.RESOLVED
  }
  case object PENDING extends zio.aws.applicationinsights.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Status =
      software.amazon.awssdk.services.applicationinsights.model.Status.PENDING
  }
  case object RECURRING extends zio.aws.applicationinsights.model.Status {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.Status =
      software.amazon.awssdk.services.applicationinsights.model.Status.RECURRING
  }
}
