package zio.aws.applicationinsights.model
import scala.jdk.CollectionConverters._
sealed trait ResolutionMethod {
  def unwrap: software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod
}
object ResolutionMethod {
  def wrap(
      value: software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod
  ): zio.aws.applicationinsights.model.ResolutionMethod = value match {
    case software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod.MANUAL =>
      val r = MANUAL
      r
    case software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod.AUTOMATIC =>
      val r = AUTOMATIC
      r
    case software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod.UNRESOLVED =>
      val r = UNRESOLVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.applicationinsights.model.ResolutionMethod {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod =
      software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod.UNKNOWN_TO_SDK_VERSION
  }
  case object MANUAL
      extends zio.aws.applicationinsights.model.ResolutionMethod {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod =
      software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod.MANUAL
  }
  case object AUTOMATIC
      extends zio.aws.applicationinsights.model.ResolutionMethod {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod =
      software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod.AUTOMATIC
  }
  case object UNRESOLVED
      extends zio.aws.applicationinsights.model.ResolutionMethod {
    override def unwrap
        : software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod =
      software.amazon.awssdk.services.applicationinsights.model.ResolutionMethod.UNRESOLVED
  }
}
