package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{Remarks, WorkloadId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeWorkloadResponse(
    workloadId: Optional[WorkloadId] = Optional.Absent,
    workloadRemarks: Optional[Remarks] = Optional.Absent,
    workloadConfiguration: Optional[
      zio.aws.applicationinsights.model.WorkloadConfiguration
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadResponse = {
    import DescribeWorkloadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadResponse
      .builder()
      .optionallyWith(
        workloadId.map(value => WorkloadId.unwrap(value): java.lang.String)
      )(_.workloadId)
      .optionallyWith(
        workloadRemarks.map(value => Remarks.unwrap(value): java.lang.String)
      )(_.workloadRemarks)
      .optionallyWith(
        workloadConfiguration.map(value => value.buildAwsValue())
      )(_.workloadConfiguration)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeWorkloadResponse.ReadOnly =
    zio.aws.applicationinsights.model.DescribeWorkloadResponse
      .wrap(buildAwsValue())
}
object DescribeWorkloadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.DescribeWorkloadResponse =
      zio.aws.applicationinsights.model.DescribeWorkloadResponse(
        workloadId.map(value => value),
        workloadRemarks.map(value => value),
        workloadConfiguration.map(value => value.asEditable)
      )
    def workloadId: Optional[WorkloadId]
    def workloadRemarks: Optional[Remarks]
    def workloadConfiguration: Optional[
      zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly
    ]
    def getWorkloadId: ZIO[Any, AwsError, WorkloadId] =
      AwsError.unwrapOptionField("workloadId", workloadId)
    def getWorkloadRemarks: ZIO[Any, AwsError, Remarks] =
      AwsError.unwrapOptionField("workloadRemarks", workloadRemarks)
    def getWorkloadConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("workloadConfiguration", workloadConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadResponse
  ) extends zio.aws.applicationinsights.model.DescribeWorkloadResponse.ReadOnly {
    override val workloadId: Optional[WorkloadId] = zio.aws.core.internal
      .optionalFromNullable(impl.workloadId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.WorkloadId(value)
      )
    override val workloadRemarks: Optional[Remarks] = zio.aws.core.internal
      .optionalFromNullable(impl.workloadRemarks())
      .map(value => zio.aws.applicationinsights.model.primitives.Remarks(value))
    override val workloadConfiguration: Optional[
      zio.aws.applicationinsights.model.WorkloadConfiguration.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.workloadConfiguration())
      .map(value =>
        zio.aws.applicationinsights.model.WorkloadConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadResponse
  ): zio.aws.applicationinsights.model.DescribeWorkloadResponse.ReadOnly =
    new Wrapper(impl)
}
