package zio.aws.applicationinsights.model
import zio.ZIO
import zio.aws.applicationinsights.model.primitives.{
  AccountId,
  WorkloadId,
  ComponentName,
  ResourceGroupName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeWorkloadRequest(
    resourceGroupName: ResourceGroupName,
    componentName: ComponentName,
    workloadId: WorkloadId,
    accountId: Optional[AccountId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadRequest = {
    import DescribeWorkloadRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadRequest
      .builder()
      .resourceGroupName(
        ResourceGroupName.unwrap(resourceGroupName): java.lang.String
      )
      .componentName(ComponentName.unwrap(componentName): java.lang.String)
      .workloadId(WorkloadId.unwrap(workloadId): java.lang.String)
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .build()
  }
  def asReadOnly
      : zio.aws.applicationinsights.model.DescribeWorkloadRequest.ReadOnly =
    zio.aws.applicationinsights.model.DescribeWorkloadRequest
      .wrap(buildAwsValue())
}
object DescribeWorkloadRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.applicationinsights.model.DescribeWorkloadRequest =
      zio.aws.applicationinsights.model.DescribeWorkloadRequest(
        resourceGroupName,
        componentName,
        workloadId,
        accountId.map(value => value)
      )
    def resourceGroupName: ResourceGroupName
    def componentName: ComponentName
    def workloadId: WorkloadId
    def accountId: Optional[AccountId]
    def getResourceGroupName: ZIO[Any, Nothing, ResourceGroupName] =
      ZIO.succeed(resourceGroupName)
    def getComponentName: ZIO[Any, Nothing, ComponentName] =
      ZIO.succeed(componentName)
    def getWorkloadId: ZIO[Any, Nothing, WorkloadId] = ZIO.succeed(workloadId)
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadRequest
  ) extends zio.aws.applicationinsights.model.DescribeWorkloadRequest.ReadOnly {
    override val resourceGroupName: ResourceGroupName =
      zio.aws.applicationinsights.model.primitives
        .ResourceGroupName(impl.resourceGroupName())
    override val componentName: ComponentName =
      zio.aws.applicationinsights.model.primitives
        .ComponentName(impl.componentName())
    override val workloadId: WorkloadId =
      zio.aws.applicationinsights.model.primitives.WorkloadId(impl.workloadId())
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value =>
        zio.aws.applicationinsights.model.primitives.AccountId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.applicationinsights.model.DescribeWorkloadRequest
  ): zio.aws.applicationinsights.model.DescribeWorkloadRequest.ReadOnly =
    new Wrapper(impl)
}
